<?php $offset = $loggedIn['set_offset']; ?>
<div class="card">
    <div class="card-header">
        <div class="card-title">
            <span>User Profile </span>
            <?php if(count($devices) > 0): ?>
            <a href="javascript:void(0)" data-toggle="modal" data-target="#device-modal"><i class="fa fa-info-circle text-gray"></i></a>
            <?php endif; ?>
        </div>
    </div>
    <div class="card-body">
        <?php $verified = (boolval( $user['email_verification_status'])) ? '<i class="fa fa-check-square text-success ml-1"></i>' : '';?>
        <div class="form-group row">
            <div class="col-8">
                <div class="form-row">
                    <label class="col-sm-2 col-form-label">Email</label>
                    <div class="align-self-center col-sm-10"><?=$user['email'].$verified;?></div>
                </div>
                <div class="form-row">
                    <label class="col-sm-2 col-form-label">Is Email verified?</label>
                    <div class="align-self-center col-sm-10"><?=(boolval($user['email_verification_status'])) ? "Yes" : "No";?></div>
                </div>
                <div class="form-row">
                    <label class="col-sm-2 col-form-label">User Since</label>
                    <div class="align-self-center col-sm-10"><?=date(DATETIME_FORMAT,$user['created_at'] + $offset);?> (<?=timespan($user['created_at'], time(), 1).' ago';?>)</div>
                </div>
                <div class="form-row">
                    <label class="col-sm-2 col-form-label">Total Spent</label>
                    <div class="align-self-center col-sm-10"><i class="fa fa-dollar-sign text-gray"></i> <?=number_format($total_spent,2);?></div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view(ADMIN_VIEW_DIR.'/auth/transaction_history/index',['offset'=>$offset]);?>
<?php if(count($devices) > 0): ?>
<div class="modal fade" id="device-modal">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header d-flex">
                <h4 class="modal-title">User Devices</h4>
                <button type="button" class="align-self-center btn btn-sm btn-outline-dark justify-content-between" data-dismiss="modal"><i class="fa fa-times"></i></button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered table-responsive">
                    <tr>
                        <th class="text-center">Wholesaler User</th>
                        <th class="text-center">Device Type</th>
                        <th class="text-center">Device Name</th>
                        <th class="text-center">Device ID</th>
                        <th class="text-center">App Version</th>
                        <th class="text-center">Logged In At</th>
                    </tr>
                    <?php foreach($devices as $device){ ?>
                        <tr>
                            <td class="font-weight-bold text-left text-indigo"><?=$device['wholesaler_user'];?></td>
                            <td class="font-weight-bold text-center text-primary"><?=($device['device_type'] == 'I') ? 'iOS' : (($device['device_type'] == 'A') ? 'Android' : (($device['device_type'] == 'M') ? 'Mac' : ''));?></td>
                            <td class="font-weight-bold text-center text-primary"><?=$device['device_name'];?></td>
                            <td class="font-weight-bold text-center text-success"><?=$device['device_unique_id'];?></td>
                            <td class="font-weight-bold text-center text-success">v<?=$device['app_version'];?></td>
                            <td class="font-weight-bold text-center text-maroon"><?=date(DATETIME_FORMAT,($device['login_at'] + $offset));?></td>
                        </tr>
                    <?php } ?>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-dark" data-dismiss="modal">Cancel</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<?php endif; ?>