<?php
    $import_auth = $this->authlib->isAuthorizedLink($permissions,$module,'import');
    if($import_auth):
?>
<div class="modal fade" id="import-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header d-flex">
                <h4 class="modal-title">Import <?=plural($page_title);?></h4>
                <button type="button" class="align-self-center btn btn-sm btn-outline-dark justify-content-between" data-dismiss="modal"><i class="fa fa-times"></i></button>
            </div>
            <?php echo form_open_multipart('#', $forms['frm_import']); ?>
            <div class="modal-body">
                <div class="form-group" id="import-form">
                    <label>Excel File</label>
                    <?php
                        $data = array(
                            'type' => 'file',
                            'name' => 'import',
                            'class' => 'form-control dropify',
                            'placeholder' => 'Excel File',
                            'value' => '',
                            'data-default-file' => '',
                            'accept'=>"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel"
                        );
                        echo form_input($data);
                    ?>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-theme-success" id="import-button">Import</button>
                <button type="button" class="btn btn-theme-cancel" data-dismiss="modal">Cancel</button>
            </div>
            <?php echo form_close(); ?>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<div class="modal fade" id="import-history-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header d-flex">
                <h4 class="modal-title">Import Statistics</h4>
                <button type="button" class="align-self-center btn btn-sm btn-outline-dark justify-content-between" data-dismiss="modal"><i class="fa fa-times"></i></button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered" id="import-result">
                    <tr>
                        <th>Total requested records</th>
                        <td class="font-weight-bold text-right text-primary" id="totalRequested"></td>
                    </tr>
                    <tr>
                        <th>Total inserted records</th>
                        <td class="font-weight-bold text-right text-success" id="totalInserted"></td>
                    </tr>
                    <tr>
                        <th>Total updated records</th>
                        <td class="font-weight-bold text-right text-success" id="totalUpdated"></td>
                    </tr>
                    <tr>
                        <th>Total skipped records</th>
                        <td class="font-weight-bold text-right text-warning" id="totalSkipped"></td>
                    </tr>
                    <tr>
                        <th>Total unchanged records</th>
                        <td class="font-weight-bold text-right text-warning" id="totalUnchanged"></td>
                    </tr>
                    <tr>
                        <th>Error while inserting records</th>
                        <td class="font-weight-bold text-right text-danger" id="totalErrorWhileInsert"></td>
                    </tr>
                    <tr>
                        <th>Error while updating records</th>
                        <td class="font-weight-bold text-right text-danger" id="totalErrorWhileUpdate"></td>
                    </tr>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-theme-cancel" data-dismiss="modal">Cancel</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<?php endif; ?>