<div class="modal-body">
    <?php echo form_hidden('question_id', ''); ?>
    <div class="form-row">
        <div class="col">
            <div class="form-group">
                <label>Question Category</label>
                <?php 
                    $category_keys = array_map(function($category){ return $category['category_id']; }, $categories);
                    $category_values = array_map(function($category){ return $category['category_label']; }, $categories);
                    $category_options = array_combine($category_keys, $category_values);
                    $extra='class="form-control select2"';
                    echo form_dropdown('question_category_id', $category_options, '', $extra);
                ?>
            </div>
        </div>
    </div>
    <div class="form-row">
        <div class="col">
            <div class="form-group">
                <label>Question</label>
                <?php
                    $data = array(
                        'type' => 'text',
                        'name' => 'question',
                        'class' => 'form-control',
                        'placeholder' => 'Question',
                        'value' => '',
                    );
                    echo form_input($data);
                ?>
            </div>
        </div>
    </div>
    <div class="form-row">
        <div class="col">
            <div class="form-group">
                <label>Question Type</label>
                <?php 
                    $options = ['truth' => 'Truth','dare' => 'Dare'];
                    $extra='class="form-control select2"';
                    echo form_dropdown('question_type', $options, '', $extra);
                ?>
            </div>
        </div>
    </div>
    <div class="form-row">
        <div class="col">
            <div class="form-group">
                <label>Status</label>
                <?php 
                    $extra='class="form-control select2"';
                    echo form_dropdown('is_active', ACTIVE_INACTIVE_OPTIONS, '', $extra);
                ?>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="submit" class="btn btn-theme-success">Save</button>
    <button type="button" class="btn btn-theme-cancel" data-dismiss="modal">Cancel</button>
</div>