<script>
    var user_device_stats_chart_dialogue, guest_user_device_stats_chart_dialogue;
    $(document).ready(function(){
        if ($("#user-device-stats").length > 0 || $("#guest-user-device-stats").length){
            $.ajax({
                url: '<?=ADMIN_AJAX_URL;?>' + 'dashboard-user-device-stats',
                type: 'GET',
                dataType: 'JSON',
                success: function (response) {
                    if(response.success){
                        user_device_stats_chart_dialogue = Highcharts.chart('user-device-stats', {
                            chart: {
                                type: 'line',renderTo: 'user-device-stats-chart',
                                events:{
                                    load: function(){
                                        $('#user-device-stats-chart').addClass('p-0');
                                    }
                                },
                            },
                            title: {text: response.data.user_title},
                            subtitle: {text: response.data.subtitle},
                            xAxis: {categories: response.data.labels,crosshair: true,title: {text: response.data.xaxistitle}},
                            yAxis: {min: 0,title: {text: response.data.yaxistitle}},
                            tooltip: {
                                headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                                pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                                '<td style="padding:0;text-align:right"><b>{point.y}</b></td></tr>',
                                footerFormat: '</table>',
                                shared: true,
                                useHTML: true
                            },
                            plotOptions: {column: {pointPadding: 0.2,borderWidth: 0}},
                            series: response.data.user_series
                        });

                        guest_user_device_stats_chart_dialogue = Highcharts.chart('guest-user-device-stats', {
                            chart: {
                                type: 'line',renderTo: 'user-device-stats-chart',
                                events:{
                                    load: function(){
                                        $('#guest-user-device-stats-chart').addClass('p-0');
                                    }
                                },
                            },
                            title: {text: response.data.guest_title},
                            subtitle: {text: response.data.subtitle},
                            xAxis: {categories: response.data.labels,crosshair: true,title: {text: response.data.xaxistitle}},
                            yAxis: {min: 0,title: {text: response.data.yaxistitle}},
                            tooltip: {
                                headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                                pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                                '<td style="padding:0;text-align:right"><b>{point.y}</b></td></tr>',
                                footerFormat: '</table>',
                                shared: true,
                                useHTML: true
                            },
                            plotOptions: {column: {pointPadding: 0.2,borderWidth: 0}},
                            series: response.data.guest_series
                        });
                    }
                }
            });
        }
        $(document).on('click','.user-device-stats-chart',function(){
            $('.user-device-stats-chart').addClass('btn-default').removeClass('btn-theme');
            $(this).addClass('btn-theme').removeClass('btn-default');
            user_device_stats_chart_dialogue.update({
                chart: {
                    type: $(this).data('type')
                }
            })
        });
        $(document).on('click','.guest-user-device-stats-chart',function(){
            $('.guest-user-device-stats-chart').addClass('btn-default').removeClass('btn-theme');
            $(this).addClass('btn-theme').removeClass('btn-default');
            guest_user_device_stats_chart_dialogue.update({
                chart: {
                    type: $(this).data('type')
                }
            })
        });
    });
</script>