<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Vpn_server_model extends My_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getOpenGateServerList($where = [], $currentTime = 0)
    {
        $this->db->select(ADMIN_VPN_SERVER_FIELD);
        $this->db->from($this->vpn_server_table . ' as vpn_servers');
        $this->db->where($where);
        get_order(['order' => 'vpn_servers.updated_at', 'type' => 'DESC']);
        $query = $this->db->get();
        $data = $query->result_array();
        array_walk($data, function (&$value, $key) use ($currentTime) {
            $value['servers'] = formatList($this->getServerList(['vpn_servers.country_id' => $value['country_id'], 'vpn_servers.updated_at >= ' => $currentTime]));
            if (count($value['servers']) == 0) {
                unset($value);
            }
        });
        return $data;
    }

    private function getServerList($where)
    {
        $this->db->select(ADMIN_VPN_SERVER_FIELD);
        $this->db->from($this->vpn_server_table . ' as vpn_servers');
        $this->db->where($where);
        get_order(['order' => 'vpn_servers.updated_at', 'type' => 'DESC']);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function getRecords($params = [])
    {
        $params = init_model_params($params);
        $this->db->select(ADMIN_VPN_SERVER_FETCH_FIELD);
        get_where($params['where']);
        $this->db->from($this->vpn_server_table . ' AS vpn_servers');
        if ($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'], $params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDatatableList($params = [])
    {
        $params = init_model_params($params);
        $this->db->select('*');
        get_where($params['where']);
        get_filter_where(VPN_SERVER_SEARCHABLE_FIELD);
        if ($params['action'] != 'count') {
            get_filter_order($_REQUEST, $params['order'], VPN_SERVER_ORDERABLE_FIELD);
            get_limit($params['limit'], $params['offset']);
        }
        $this->db->from("(SELECT 
        `vpn_servers`.`server_id`, (select countries.country FROM countries WHERE  countries.country_id =  vpn_servers.country_id) as country_name, `vpn_servers`.`recommend`, `vpn_servers`.`is_active`, `vpn_servers`.`ovpn`, `vpn_servers`.`created_at`, `vpn_servers`.`updated_at`, `vpn_servers`.`ip_address`
        FROM `vpn_servers` AS `vpn_servers`) vpn_servers");
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function insertOVPNServer($postdata){
        $server = [];
        $server['country_id'] = $postdata['country_id'];
        $server['ip_address'] = $postdata['ip_address'];
        $server['recommend'] = $postdata['recommend'] ?? 0;
        $server['is_active'] = $postdata['is_active'] ?? 0;
        $server['ovpn'] = $postdata['ovpn'] ?? '';
        $server['ping_count'] = $postdata['ping_count'] ?? 0;
        $server['created_at'] = time();
        $server['updated_at'] = time();
        $this->db->insert($this->vpn_server_table, $server);
        return $this->db->insert_id();
    }
    
    public function updateOVPNServer($postdata){
        $server = [];
        if(isset($postdata['country_id'])){ $server['country_id'] = $postdata['country_id']; }
        if(isset($postdata['ip_address'])){ $server['ip_address'] = $postdata['ip_address']; }
        if(isset($postdata['recommend'])){ $server['recommend'] = $postdata['recommend'] ?? 0; }
        if(isset($postdata['is_active'])){ $server['is_active'] = $postdata['is_active'] ?? 0; }
        if(isset($postdata['ovpn'])){ $server['ovpn'] = $postdata['ovpn'] ?? ''; }
        if(isset($postdata['ping_count'])){ $server['ping_count'] = $postdata['ping_count'] ?? 0; }
        if(isset($postdata['updated_at'])){ $server['updated_at'] = time(); }
        $this->db->where('server_id', $postdata['server_id']);
        return $this->db->update($this->vpn_server_table, $server);
    }

    public function insertVPNServer($postData)
    {
        $currentTime = time();
        $postData['created_at'] = $currentTime;
        $postData['updated_at'] = $currentTime;
        unset($postData['server_id']);
        $this->db->insert($this->vpn_server_table, $postData);
        return $this->db->insert_id();
        // $this->countryUpdateExisting($postData['country_id'], $currentTime);
    }

    public function updateExisting($postdata, $id)
    {
        $currentTime = time();
        $postdata['updated_at'] = $currentTime;
        unset($postdata['server_id']);
        $this->db->where('server_id', $id);
        $flag = $this->db->update($this->vpn_server_table, $postdata);
        if (!$flag) {
            return FALSE;
        }
        // $this->countryUpdateExisting($postdata['country_id'], $currentTime);
        return $this->db->affected_rows();
    }

    public function countryUpdateExisting($id, $currentTime)
    {
        $this->db->select(ADMIN_VPN_SERVER_FETCH_FIELD);
        get_where(['country_id' => $id,'is_active' => '1']);
        $this->db->from($this->vpn_server_table . ' AS vpn_servers');
        $query = $this->db->get()->num_rows();
        if($query == 0){
            $postdata['is_active'] = 0;
        }
        $postdata['updated_at'] = $currentTime;
        $this->db->where('country_id', $id);
        $flag = $this->db->update($this->countries_table, $postdata);
        if (!$flag) {
            return FALSE;
        }
        //return $this->db->affected_rows();
    }

    public function getRow($id, $flag = "")
    {
        if ($flag == "") {
            return $this->getRecords(['where' => ['vpn_servers.server_id' => $id], 'action' => 'row']);
        }
        return $this->getAdminRecords(['where' => ['vpn_servers.server_id' => $id], 'action' => 'row']);
    }

    public function checkIfExist($ip_address, $id = NULL)
    {
        $where = ['vpn_servers.ip_address' => $ip_address];
        if ($id) {
            $where['server_id != '] = $id;
        }
        return $this->getRecords(['where' => $where, 'action' => 'row']);
    }

    public function getAdminRecords($params = [])
    {
        $params = init_model_params($params);
        $this->db->select(ADMIN_VPN_SERVER_FIELD);
        get_where($params['where']);
        $this->db->from($this->vpn_server_table . ' AS vpn_servers');
        if ($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'], $params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getRemainingVPNServers($params = [])
    {
        $params = init_model_params($params);
        $this->db->select('cnt.country_id, count(vpn.country_id), (10 - count(vpn.country_id)) as remcount');
        $this->db->from($this->countries_table . ' AS cnt');
        $this->db->join($this->vpn_server_table . ' AS vpn','vpn.country_id = cnt.country_id AND vpn.is_active = 1','LEFT');
        $this->db->group_by('cnt.country_id');
        $this->db->having('remcount > 0');
        $query = $this->db->get();
        return get_data($params, $query);
    }
    
    // Testing 25-01-2024
    public function UpdateTheOVPNServers($postdata){
        $userServer = $this->getAdminRecords(['where' => ['vpn_servers.server_id' => $postdata['server_id']], 'action' => 'row']);
        if(!empty($userServer)){
            $ovpn_file = "";
            if(!empty($postdata['filepath'])){
                $ovpn_file_path =OVPN_SERVER_UPDATE_PATH.$postdata['filepath'];
                $ovpn_file = file_get_contents($ovpn_file_path);
            }
            $raw = [
                'server_id'=>$postdata['server_id'],
                'ip_address'=>$postdata['ip_address'],
                'ovpn'=>$ovpn_file,
                'updated_at'=>time(),
            ];
            $this->db->where(['vpn_servers.server_id'=>$postdata['server_id']]);
            $flag = $this->db->update($this->vpn_server_table, $raw);
            if (!$flag) {
                return FALSE;
            }
        }
        return $userServer;
    }
    // Testing 25-01-2024

    public function getCountryList(){
        $this->db->from($this->countries_table . ' as country');
        $this->db->where(['country.is_active'=>1]);
        $countries_query = $this->db->get();
        return $countries_query->result_array();
    }

    public function getServerCountryList($id){
        $this->db->from($this->vpn_server_table . ' as vpn_server');
        $this->db->where(['vpn_server.country_id'=>$id,'vpn_server.is_active'=>1]);
        $countries_query = $this->db->get();
        return $countries_query->result_array();
    }

    public function serverCountryCheck(){
        $countries_query = $this->getCountryList();
        foreach($countries_query as $country){
            $vpn_server_query = $this->getServerCountryList($country['country_id']);
            if(empty($vpn_server_query)){
                $row = ['is_active'=>0];
                $this->country_model->updateExisting($row, $country['country_id']);
            }
        }
    }

    public function OldServersOvpn($postdata){
        $userServer = $this->getAdminRecords(['where' => ['vpn_servers.server_id' => $postdata['server_id']], 'action' => 'row']);
        if(!empty($userServer)){
            $row = ['is_active'=>$postdata['is_active']];
            $this->updateExisting($row, $postdata['server_id']);
        }
        $userServer = $this->getAdminRecords(['where' => ['vpn_servers.server_id' => $postdata['server_id']], 'action' => 'row']);
        return $userServer;
    }

    public function getNewRecordsForNewServers($postdata){
        $userServer = $this->getAdminRecords(['where' => ['vpn_servers.ip_address' => $postdata['ip_address']], 'action' => 'row']);
        return $userServer;
    }
    public function getOldRecordsForNewServers($postdata){
        $userServer = $this->getAdminRecords(['where' => ['vpn_servers.server_id' => $postdata['server_id']], 'action' => 'row']);
        return $userServer;
    }

    public function OldAndNewAddOrUpdateTheOVPNServers($new_servers){
        if(!empty($new_servers)){
            foreach($new_servers as $new_server){
                $getCountry = $this->country_model->getCountry($new_server['country_code']);
                if(!empty($getCountry)){
                    if($getCountry['is_active'] == 0){
                        $this->country_model->addOrUpdateCountry($getCountry);
                    }
                    //replace the inactive server to active and update the server
                    $userServer = $this->getPyRecords([
                        'where' => [
                            'vpn_servers.country_id' => $getCountry['country_id'],
                            'vpn_servers.is_active' => 0
                        ],
                        'order' => ['order'=>'vpn_servers.updated_at', 'type'=>'desc'],
                        'action' => 'row'
                    ]);
                    if(!empty($userServer)){
                        $new_server['server_id'] = $userServer['server_id'];
                        $new_server['country_id'] = $getCountry['country_id'];
                        $new_server['is_active'] = 1;
                        $this->UpdateNewServer($new_server);
                    }else{
                        $userServer = $this->getPyRecords([
                            'where' => [
                                'vpn_servers.country_id' => $getCountry['country_id'],
                                'vpn_servers.ip_address'=>$new_server['ip_address']
                            ], 'action' => 'row'
                        ]);
                        if(!empty($userServer)){
                            $new_server['server_id'] = $userServer['server_id'];
                            $new_server['country_id'] = $getCountry['country_id'];
                            $this->UpdateNewServer($new_server);
                        }else{
                            $new_server['country_id'] = $getCountry['country_id'];
                            $this->AddNewServer($new_server);
                        }
                    }
                }
            }
        }
    }

    public function AddNewServer($postdata){
        $ovpn_file = "";
        if(!empty($postdata['filepath'])){
            $ovpn_file = file_get_contents($postdata['filepath']);
        }
        $get_country = $this->country_model->addOrUpdateCountry($postdata);
        $raw = [
            'ip_address'=>$postdata['ip_address'],
            'country_id'=>$get_country['country_id'],
            'ovpn'=>$ovpn_file,
            'recommend'=>0,
            'ping_count'=>0,
            'is_active'=>$postdata['is_active'],
            'created_at'=>time(),
            'updated_at'=>time(),
        ];
        $flag = $this->db->insert($this->vpn_server_table, $raw);
        if (!$flag) {
            return FALSE;
        }
    }

    public function UpdateNewServer($postdata){
        $ovpn_file = "";
        if(!empty($postdata['filepath'])){
            $ovpn_file = file_get_contents($postdata['filepath']);
        }
        $raw = [
            'country_id'=>$postdata['country_id'],
            'ip_address'=>$postdata['ip_address'],
            'ovpn'=>$ovpn_file,
            'recommend'=>0,
            'is_active'=>$postdata['is_active'],
            'updated_at'=>time(),
        ];
        $this->db->where(['vpn_servers.server_id'=>$postdata['server_id']]);
        $flag = $this->db->update($this->vpn_server_table, $raw);
        if (!$flag) {
            return FALSE;
        }
        $userServer = $this->getAdminRecords(['where' => ['vpn_servers.server_id' => $postdata['server_id']], 'action' => 'row']);
        return $userServer;
    }

    public function getPyRecords($params = [])
    {
        $params = init_model_params($params);
        $this->db->select(PY_ADMIN_VPN_SERVER_FETCH_FIELD);
        get_where($params['where']);
        $this->db->from($this->vpn_server_table . ' AS vpn_servers');
        $this->db->join($this->countries_table.' AS country','country.country_id = vpn_servers.country_id');
        if ($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'], $params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function updateInactiveServers($ip_address){
        $row = [
            'is_active'=>1,
            'updated_at'=>time()
        ];
        $this->db->where('vpn_servers.is_active',0);
        $this->db->where_in('vpn_servers.ip_address', $ip_address);
        $flag = $this->db->update($this->vpn_server_table, $row);
        if (!$flag) {
            return FALSE;
        }
        return TRUE;
    }
}
