<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Module_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function getRow($id)
    {
        return $this->getRecords(['where'=>['module_id'=>$id],'action'=>'row']);
    }

    public function getRowByName($module_title)
    {
        return $this->getRecords(['where' => ['module_title' => $module_title], 'action' => 'row']);
    }

    public function checkIfExist($module_title, $id = NULL)
    {
        $where = ['module_title' => $module_title];
        if($id){ $where['module_id != '] = $id; }
        return $this->getRecords(['where' => $where, 'action' => 'row']);
    }

    public function getRecords($params = [])
    {
        $params = init_model_params($params);
        get_where($params['where']);
        $this->db->from($this->module_table);
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDatatableList($params)
    {
        $params = init_model_params($params);
        $this->db->select('module.*');
        get_where($params['where']);
        get_filter_where(MODULES_SEARCHABLE_FIELDS);
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], MODULES_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        $this->db->from($this->module_table . ' AS module');
        $query = $this->db->get();
        return get_data($params, $query);
    }

    private function addModule($postdata)
    {
        $row = [
            'module_title' => $postdata['module_title'],
            'module_slug' => url_title($postdata['module_title'],'-',TRUE),
            'is_active' => $postdata['is_active'],
            'created_at' => time(),
            'updated_at' => time(),
        ];
        $flag = $this->db->insert($this->module_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->insert_id();
    }

    private function attachMethod($module_id, $module_methods)
    {
        $module_method_data = array_map(function($method_id) use ($module_id) {
            return [
                'module_id' => $module_id,
                'method_id' => $method_id,
            ];
        }, $module_methods);
        $flag = $this->db->insert_batch($this->module_method_table,$module_method_data);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }
    
    private function detachMethod($module_id, $module_methods)
    {
        $this->db->where('module_id', $module_id);
        $this->db->where_in('method_id', $module_methods);
        $flag = $this->db->delete($this->module_method_table);
        if (!$flag) {
            return false;
        }
        return $this->db->affected_rows();
    }

    public function addNew($postdata)
    {
        $this->db->trans_start();
        $id = $this->addModule($postdata);
        $this->attachMethod($id, $postdata['module_methods']);
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE)
        {
            return FALSE;
        }
        return $id;
    }

    private function updateModule($postdata, $id){
        $row = [
            'module_title' => $postdata['module_title'],
            'module_slug' => url_title($postdata['module_title'], '-', true),
            'is_active' => $postdata['is_active'],
            'updated_at' => time(),
        ];
        $this->db->where('module_id', $id);
        $flag = $this->db->update($this->module_table, $row);
        if (!$flag) {
            return false;
        }
        return $this->db->affected_rows();
    }

    public function updateExisting($postdata, $id, $inserted_methods = [], $deleted_methods = [])
    {
        $this->db->trans_start();
        $this->updateModule($postdata, $id);
        if(!empty($inserted_methods)){
            $this->attachMethod($id, $inserted_methods);
        }
        if(!empty($deleted_methods)){
            $this->detachMethod($id, $deleted_methods);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE)
        {
            return FALSE;
        }
        return TRUE;
    }

    public function getModuleMethods($module_id){
        $this->db->where('module_id',$module_id);
        $this->db->from($this->module_method_table);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function getModuleMethodsInfo($module_id){
        $this->db->select('module_method.*,method.method_title');
        $this->db->where('module_id',$module_id);
        $this->db->from($this->module_method_table.' AS module_method');
        $this->db->join($this->method_table.' AS method','method.method_id = module_method.method_id');
        $query = $this->db->get();
        return $query->result_array();
    }
}