<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Guest_user_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function getRow($id)
    {
        return $this->getRecords(['where'=>['device.user_device_id'=>$id],'action'=>'row']);
    }

    /* public function getDatatableList($params = [])
    {
        $where = [];
        $params = init_model_params($params);
       
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_DEVICE_SUBSCRIPTION);
        $this->db->select($fields);
        $this->db->from($this->user_subscription_table.' AS usubscription');
        $this->db->join($this->user_device_table.' AS device','device.user_device_id = usubscription.user_device_id AND usubscription.user_id IS NULL');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id AND web_subscription.is_latest_webhook = 1','LEFT');
        $this->db->where('usubscription.is_latest_webhook_subscription',1);
        $user_trans_query = $this->db->get_compiled_select();

        // $wholesaler = 'IF(device.wholesaler_user IS NULL and web_subscription.notification_store != "'.APP_STORE_APPLE.'",concat(web_subscription.original_transaction_id,"@vpw.vpnproxymaster.app"),device.wholesaler_user) AS wholesaler_user';
        $wholesaler = 'IF(
            web_subscription.notification_store != "'.APP_STORE_APPLE.'" AND device.wholesaler_user IS NULL,
            CONCAT(web_subscription.original_transaction_id,"@vpw.vpnproxymaster.app"),
            IFNULL(
                device.wholesaler_user,
                IF(web_subscription.notification_store IS NOT NULL,CONCAT(device.device_unique_id,"@vpw.vpnproxymaster.app"),"")
            )
        ) AS wholesaler_user';
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_DEVICE, ['device.created_at',$wholesaler]);
        $this->db->select($fields);
        get_where($params['where']);
        get_filter_where(DEVICE_USERS_SEARCHABLE_FIELDS);
        $this->db->from($this->user_subscription_table.' AS usubscription');
        $this->db->join($this->user_device_table.' AS device','device.user_device_id = usubscription.user_device_id AND usubscription.user_id IS NULL');
        $this->db->join('('.$user_trans_query.') AS web_subscription','web_subscription.user_device_id = device.user_device_id','LEFT');
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], DEVICE_USERS_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    } */

    public function _getDatatableList($params = [])
    {
        $params = init_model_params($params);
        $wholesaler = 'IF(
            web_subscription.notification_store != "'.APP_STORE_APPLE.'" AND device.wholesaler_user IS NULL,
            CONCAT(web_subscription.original_transaction_id,"@vpw.vpnproxymaster.app"),
            IFNULL(
                device.wholesaler_user,
                IF(web_subscription.notification_store IS NOT NULL,CONCAT(device.device_unique_id,"@vpw.vpnproxymaster.app"),"")
            )
        ) AS wholesaler_user';
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_DEVICE, ['device.created_at',$wholesaler]);
        $this->db->select($fields);
        get_where($params['where']);
        get_filter_where(DEVICE_USERS_SEARCHABLE_FIELDS);
        $this->db->from($this->user_device_table.' AS device');
        $this->db->join($this->user_subscription_table.' AS usubscription','device.user_device_id = usubscription.user_device_id AND usubscription.user_id IS NULL');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id AND web_subscription.is_latest_webhook = 1','LEFT');
        $this->db->join($this->user_device_login_table.' AS device_user','device_user.user_device_id = device.user_device_id','LEFT');
        $this->db->where('device_user.user_device_login_id IS NULL', NULL, FALSE);
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], DEVICE_USERS_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDatatableList($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_DEVICE, ['device.created_at']);
        $this->db->select($fields);
        get_where($params['where']);
        get_filter_where(DEVICE_USERS_SEARCHABLE_FIELDS);
        $this->db->from($this->user_device_table.' AS device');
        $this->db->join($this->user_subscription_table.' AS usubscription','device.user_device_id = usubscription.user_device_id AND usubscription.user_id IS NULL and usubscription.is_latest_webhook_subscription = 1','LEFT');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id AND web_subscription.is_latest_webhook = 1','LEFT');
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], DEVICE_USERS_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function totalRevenue($params = [])
    {
        $params = init_model_params($params);
        $this->db->select('sum(web_subscription.price) AS total');
        get_where($params['where']);
        get_filter_where(USERS_SEARCHABLE_FIELDS);
        $this->db->from($this->user_subscription_table.' AS usubscription');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id');
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], USERS_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }
    
    public function _getTransactions($params = [])
    {
        $params = init_model_params($params);
        /* $this->db->select('web_subscription_tran.*');
        $this->db->from($this->webhook_subscription_table.' AS web_subscription_tran');
        $transaction_query = $this->db->get_compiled_select(); */
        
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_DEVICE_SUBSCRIPTION);
        $this->db->select($fields);
        $this->db->from($this->user_subscription_table.' AS usubscription');
        $this->db->join($this->user_device_table.' AS device','device.user_device_id = usubscription.user_device_id AND usubscription.user_id IS NULL');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id','LEFT');
        $user_trans_query = $this->db->get_compiled_select();

        $fields = array_merge(API_FIELDS_DEVICE, API_FIELDS_WEBHOOK_SUBSCRIPTION);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_device_table.' AS device');
        $this->db->join('('.$user_trans_query.') AS web_subscription','web_subscription.user_device_id = device.user_device_id');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getTransactions($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_DEVICE, API_FIELDS_WEBHOOK_SUBSCRIPTION);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_device_table.' AS device');
        $this->db->join($this->user_subscription_table.' AS usubscription','device.user_device_id = usubscription.user_device_id AND usubscription.user_id IS NULL and usubscription.is_latest_webhook_subscription = 1','LEFT');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id AND web_subscription.is_latest_webhook = 1','LEFT');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getAllTransactions($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_DEVICE, API_FIELDS_WEBHOOK_SUBSCRIPTION);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_device_table.' AS device');
        $this->db->join($this->user_subscription_table.' AS usubscription','device.user_device_id = usubscription.user_device_id AND usubscription.user_id IS NULL','LEFT');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id','LEFT');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getRecords($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_DEVICE,['device.created_at']);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_device_table.' AS device');
        $this->db->join($this->user_subscription_table.' AS usubscription','usubscription.user_device_id = device.user_device_id AND usubscription.user_id IS NULL and usubscription.is_latest_webhook_subscription = 1');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDeviceDetails($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_DEVICE,['device.created_at']);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_device_table.' AS device');
        $this->db->join($this->user_device_login_table.' AS device_user','device_user.user_device_id = device.user_device_id','LEFT');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function deactiveSubscriptionPlan($wholesalers){
        $row = [
            'is_expired_from_sdk' => TRUE,
            'updated_at' => time(),
        ];
        $this->db->where_in('wholesaler_user',$wholesalers);
        $flag = $this->db->update($this->user_device_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->affected_rows();
    }
    
    public function deactiveSubscriptionPlanSingle($wholesaler){
        $row = [
            'is_expired_from_sdk' => TRUE,
            'updated_at' => time(),
        ];
        $this->db->where('wholesaler_user',$wholesaler);
        $flag = $this->db->update($this->user_device_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->affected_rows();
    }

    public function deactiveSubscriptionPlanSingleById($wholesaler){
        $row = [
            'is_expired_from_sdk' => TRUE,
            'updated_at' => time(),
        ];
        $this->db->where('user_device_id',$wholesaler);
        $flag = $this->db->update($this->user_device_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->affected_rows();
    }
    
    public function activeSubscriptionPlan($wholesaler){
        $row = [
            'is_expired_from_sdk' => FALSE,
            'updated_at' => time(),
        ];
        $this->db->where('user_device_id',$wholesaler);
        $flag = $this->db->update($this->user_device_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->affected_rows();
    }
}