<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Datatable_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }
    
    private function getTableInfo($module){
        $info = [];
        switch ($module) {
            case 'category': $info = ['table' => $this->category_table, 'primary_key' => 'category_id']; break;
            case 'question': $info = ['table' => $this->question_table, 'primary_key' => 'question_id']; break;
            case 'module': $info = ['table' => $this->module_table, 'primary_key' => 'module_id']; break;
            case 'method': $info = ['table' => $this->method_table, 'primary_key' => 'method_id']; break;
            case 'role': $info = ['table' => $this->role_table, 'primary_key' => 'role_id']; break;
            case 'admin': $info = ['table' => $this->admin_table, 'primary_key' => 'admin_id']; break;
            case 'user': $info = ['table' => $this->user_table, 'primary_key' => 'user_id']; break;
            case 'country':
                $info = ['table' => $this->countries_table, 'primary_key' => 'country_id'];
                break;
            case 'vpn-server':
                $info = ['table' => $this->vpn_server_table, 'primary_key' => 'server_id'];
                break;
            case 'open-gate-server':
                $info = ['table' => $this->open_get_server_table, 'primary_key' => 'id'];
                break;
        }
        return $info;
    }

    public function updateStatusBulk($params)
    {
        $info = $this->getTableInfo($params['module']);
        $table = $info['table'];
        $primary_key = $info['primary_key'];
        
        $row = ['is_active' => $params['status'],'updated_at' => time()];
        $this->db->where_in($primary_key, explode(',',$params['ids']));
        $this->db->where('is_active !=', $params['status']);
        $flag = $this->db->update($table, $row);
        if (!$flag) {
            return false;
        }
        return $this->db->affected_rows();
    }

    public function updateStatus($params)
    {
        $info = $this->getTableInfo($params['module']);
        $table = $info['table'];
        $primary_key = $info['primary_key'];

        $row = ['is_active' => $params['status'],'updated_at' => time()];
        $this->db->where($primary_key, $params['id']);
        $flag = $this->db->update($table, $row);
        if (!$flag) {
            return false;
        }
        return $this->db->affected_rows();
    }
    
    private function beforeDelete($table, $primary_key, $id){
        $this->db->where($primary_key, $id);
        $query = $this->db->get($table);
        return $query->row_array();
    }
    
    private function unlinkFiles($row){
        $imageFields = ['admin_profilepic'];
        foreach($row as $key=>$val):
            if(in_array($key,$imageFields)){ unlink_my_file($val); }
        endforeach;
    }

    public function deleteRecord($params)
    {
        $info = $this->getTableInfo($params['module']);
        $table = $info['table'];
        $primary_key = $info['primary_key'];
        $row = $this->beforeDelete($table, $primary_key, $params['id']);
        if(!$row){
            return false;
        }
        $this->db->where($primary_key, $params['id']);
        $flag = $this->db->delete($table);
        if (!$flag) {
            return false;
        }
        $this->unlinkFiles($row);
        return $this->db->affected_rows();
    }
}