<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Cron_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function deleteMySessions($where){
        get_where($where);
        return $this->db->delete($this->ci_session_table);
    }
    
    public function getSubscriptionAnalytics($params = [])
    {
        $params = init_model_params($params);
        $this->db->select(API_FIELDS_SUBSCRIPTION_ANALYTICS);
        get_where($params['where']);
        $this->db->from($this->subscription_analytics_table.' AS subscription_analytic');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function insertSubscriptionAnalyticsData($analytics){
        $analytics_data = [
            'month' => $analytics['month'],
            'year' => $analytics['year'],
            'users' => $analytics['users'],
            'new_users' => $analytics['new_users'],
            'guest_users' => $analytics['guest_users'],
            'new_guest_users' => $analytics['new_guest_users'],
            'active_guests' => $analytics['active_guests'],
            'active_users' => $analytics['active_users'],
            'expired_guests' => $analytics['expired_guests'],
            'expired_users' => $analytics['expired_users'],
            'active_trial_users' => $analytics['active_trial_users'],
            'active_trial_guests' => $analytics['active_trial_guests'],
            'created_at' => time()
        ];
        $flag = $this->db->insert($this->subscription_analytics_table, $analytics_data);
        if(!$flag){
            return FALSE;
        }
        return $this->db->insert_id();
    }

    public function updateSubscriptionAnalyticsData($analytics){
        $analytics_data = [
            'users' => $analytics['users'],
            'new_users' => $analytics['new_users'],
            'guest_users' => $analytics['guest_users'],
            'new_guest_users' => $analytics['new_guest_users'],
            'active_guests' => $analytics['active_guests'],
            'active_users' => $analytics['active_users'],
            'expired_guests' => $analytics['expired_guests'],
            'expired_users' => $analytics['expired_users'],
            'active_trial_users' => $analytics['active_trial_users'],
            'active_trial_guests' => $analytics['active_trial_guests'],
        ];
        $this->db->where('month', $analytics['month']);
        $this->db->where('year', $analytics['year']);
        $flag = $this->db->update($this->subscription_analytics_table, $analytics_data);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }
    
    public function delete_old_receipts(){
        $where = [
            'receipt_created_at <=' => strtotime('-30 Days'),
            'transaction_id NOT LIKE' => 'GPA.%'
        ];
        $this->db->where($where);
        $flag = $this->db->delete($this->subscription_receipt_table);
        if (!$flag) {
            return 0;
        }
        return $this->db->affected_rows();
    }

    public function get_my_countries(){
        $last_updated_at = $this->db->where('module',$this->countries_table)->get('last_update')->row_array()['updated_at'] ?? 0;
        $query = $this->db->where('updated_at > ',$last_updated_at)->get($this->countries_table);
        $result = $query->result_array();
        return $result;
    }

    public function get_my_ovpn_servers(){
        $last_updated_at = $this->db->where('module',$this->vpn_server_table)->get('last_update')->row_array()['updated_at'] ?? 0;
        $query = $this->db->where('updated_at > ',$last_updated_at)->get($this->vpn_server_table);
        $result = $query->result_array();
        return $result;
    }

    public function bulk_insert_update_countries($countries){
        // $last_updated_at = $this->db->where('module','countries')->get('last_update')->row_array()['updated_at'] ?? 0;
        $requested_ids = array_column($countries,'country_id');
        // $result = $this->db->where_in('country_id',$requested_ids)->where('updated_at > ',$last_updated_at)->get($this->countries_table)->result_array();
        $result = $this->db->where_in('country_id',$requested_ids)->get($this->countries_table)->result_array();
        $found_ids = array_column($result, 'country_id');
        $new_records = [];
        $new_record_ids = array_diff($requested_ids, $found_ids);
        if(!empty($new_record_ids) && count($new_record_ids) > 0){
            $new_records = array_filter($countries, function($row) use ($new_record_ids){
                return in_array($row['country_id'], $new_record_ids);
            });
            mylog("New Countries");
            mylog($new_records);
            $this->db->insert_batch($this->countries_table, $new_records);
        }
        $old_records = [];
        $old_record_ids = array_intersect($requested_ids, $found_ids);
        if(!empty($old_record_ids) && count($old_record_ids) > 0){
            $old_records = array_filter($countries, function($row) use ($old_record_ids){
                return in_array($row['country_id'], $old_record_ids);
            });
            mylog("Old Countries");
            mylog($old_records);
            $this->db->update_batch($this->countries_table, $old_records, 'country_id');
        }
        // $this->db->where('module',$this->countries_table);
        // $this->db->update('last_update',['updated_at'=>time()]);
    }

    public function bulk_insert_update_ovpn_servers($ovpn_servers){
        // $last_updated_at = $this->db->where('module','vpn-servers')->get('last_update')->row_array()['updated_at'] ?? 0;
        $requested_ids = array_column($ovpn_servers,'server_id');
        // $result = $this->db->where_in('server_id',$requested_ids)->where('updated_at > ',$last_updated_at)->get($this->vpn_server_table)->result_array();
        $result = $this->db->where_in('server_id',$requested_ids)->get($this->vpn_server_table)->result_array();
        $found_ids = array_column($result, 'server_id');
        $new_records = [];
        $new_record_ids = array_diff($requested_ids, $found_ids);
        if(!empty($new_record_ids) && count($new_record_ids) > 0){
            $new_records = array_filter($ovpn_servers, function($row) use ($new_record_ids){
                return in_array($row['server_id'], $new_record_ids);
            });
            $this->db->insert_batch($this->vpn_server_table, $new_records);
            mylog("New Servers");
            mylog($new_records);
        }
        $old_records = [];
        $old_record_ids = array_intersect($requested_ids, $found_ids);
        if(!empty($old_record_ids) && count($old_record_ids) > 0){
            $old_records = array_filter($ovpn_servers, function($row) use ($old_record_ids){
                return in_array($row['server_id'], $old_record_ids);
            });
            mylog("New Servers");
            mylog($old_records);
            $this->db->update_batch($this->vpn_server_table, $old_records, 'server_id');
        }
        // $this->db->where('module',$this->vpn_server_table);
        // $this->db->update('last_update',['updated_at'=>time()]);
    }

    public function format_ovpn_server($server_data){
        $fields = [];
        $fields[] = '#HostName';
        $fields[] = 'IP';
        $fields[] = 'Score';
        $fields[] = 'Ping';
        $fields[] = 'Speed';
        $fields[] = 'CountryLong';
        $fields[] = 'CountryShort';
        $fields[] = 'NumVpnSessions';
        $fields[] = 'Uptime';
        $fields[] = 'TotalUsers';
        $fields[] = 'TotalTraffic';
        $fields[] = 'LogType';
        $fields[] = 'Operator';
        $fields[] = 'Message';
        $fields[] = 'OpenVPN_ConfigData_Base64';
        $fields = array_flip($fields);

        $ovpn = get_ovpn_file_content(base64_decode($server_data[$fields['OpenVPN_ConfigData_Base64']]), $server_data[$fields['IP']]);
        $ovpn_server_data = [
            'country_code' => $server_data[$fields['CountryShort']],
            'country' => $server_data[$fields['CountryLong']],
            'ip_address' => $server_data[$fields['IP']],
            'ovpn' => $ovpn,
            'ping_count' => $server_data[$fields['Ping']],
            'recommend' => 0,
            'is_active' => 1,
            'created_at' => time(),
            'updated_at' => time()
        ];
        return $ovpn_server_data;
    }

    public function add_ovpn_server($server_data, $is_active = 1, $is_temp = TRUE){
        $modal = ($is_temp) ? 'temp_server_model' : 'vpn_server_model';
        $is_new_country = FALSE;
        $is_new_server = FALSE;
        $this->db->trans_start();
        
        $country_where = [];
        if(isset($server_data['country_code']) && !empty($server_data['country_code'])){
            $country_where = ['country_code'=>$server_data['country_code']];
        }elseif(isset($server_data['country_id']) && !empty($server_data['country_id'])){
            $country_where = ['country_id'=>$server_data['country_id']];
        }
        $country = $this->country_model->getRecords(['action'=>'row','where'=>$country_where]);
        if(!$country){
            $countryData = [
                'country_code' => $server_data['country_code'],
                'country' => $server_data['country']
            ];
            $country_id = $this->country_model->insertCountry($countryData);
            if($country_id){
                $is_new_country = TRUE;
                $country['country_id'] = $country_id;
            }else{
                mylog("Error --- ".$this->db->error()['message']);
                return FALSE;
            }
        }

        $server_data['is_active'] = $is_active;
        $server_data['country_id'] = $country['country_id'];
        if($is_new_country){
            $is_new_server = TRUE;
        }else{
            $vpn_server = $this->$modal->getRecords(['action'=>'row','where'=>['ip_address'=>$server_data['ip_address']]]);
            if(!$vpn_server){
                $is_new_server = TRUE;
            }else{
                $update_server_data = [
                    'server_id' => $vpn_server['server_id'],
                    'ping_count' => $server_data['ping_count'],
                ];
                if($vpn_server['is_active'] != $server_data['is_active']){
                    $update_server_data['is_active'] = $server_data['is_active'];
                    $update_server_data['updated_at'] = time();
                }
                $update_vpn_server_flag = $this->$modal->updateOVPNServer($update_server_data);
                if(!$update_vpn_server_flag){
                    mylog("Error --- ".$this->db->error()['message']);
                    return FALSE;
                }
                $server_data['server_id'] = $vpn_server['server_id'];
            }
        }

        if($is_new_server){
            $server_id = $this->$modal->insertOVPNServer($server_data);
            if($server_id){
                $server_data['server_id'] = $server_id;
            }else{
                mylog("Error --- ".$this->db->error()['message']);
                return FALSE;
            }
        }
        
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE)
        {
            return FALSE;
        }
        return TRUE;

    }
}