<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Google {

    function __construct() {
        // $this->ci = & get_instance();
    }

    function get_nearby_places($params = []){
        /*
        $params = [
            'location' => $request_data['latitude'].','.$request_data['longitude'],
            'type' => $request_data['service_type'],
            'key' => GOOGLE_API_KEY,
            'radius' => MAXIMUM_NEARBY_RADIUS * 1000,
        ];
        */
        $params['key'] = $params['key'] ?? GOOGLE_API_KEY; $params['key'] = (!empty($params['key'])) ? $params['key'] : GOOGLE_API_KEY;
        $params['radius'] =  $params['radius'] * 1000; //converting meters to km
        $url = 'https://maps.googleapis.com/maps/api/place/textsearch/json'.'?'.http_build_query($params);
        $results = file_get_contents($url);
        return json_decode($results,true);
    }

    function get_distance($params = []){
        /*
        $params = [
            'units'=>'imperial',
            'origins'=>$my_location, //Concated by "," sign of latitude and longitude
            'destinations'=>$nearby_users_latlong, //Concated by "|" sign
            'key'=>GOOGLE_API_KEY
        ];
        */
        $params['origins'] = (is_array($params['origins'])) ? implode('|',$params['origins']) : $params['origins'];
        $params['destinations'] = (is_array($params['destinations'])) ? implode('|',$params['destinations']) : $params['destinations'];
        $params['units'] = $params['units'] ?? 'imperial'; $params['units'] = (!empty($params['units'])) ? $params['units'] : 'imperial';
        $params['key'] = $params['key'] ?? GOOGLE_API_KEY; $params['key'] = (!empty($params['key'])) ? $params['key'] : GOOGLE_API_KEY;
        $url = 'https://maps.googleapis.com/maps/api/distancematrix/json'.'?'.http_build_query($params);
        $results = file_get_contents($url);
        return json_decode($results,true);
    }

    function get_place_image($params = []){
        /*
        $params = [
            'center' => $my_location, //Concated by "," sign of latitude and longitude
            'markers' => $my_location, //Concated by "," sign of latitude and longitude
            'zoom' => 18,
            'size' => '1024x400',
            'format' => 'JPEG',
            'maptype' => 'roadmap',
            'key' => GOOGLE_API_KEY
        ];
        */
        $params['zoom'] = $params['zoom'] ?? '18'; $params['zoom'] = (!empty($params['zoom'])) ? $params['zoom'] : '18';
        $params['size'] = $params['size'] ?? '1024x400'; $params['size'] = (!empty($params['size'])) ? $params['size'] : '1024x400';
        $params['format'] = $params['format'] ?? 'JPEG'; $params['format'] = (!empty($params['format'])) ? $params['format'] : 'JPEG';
        $params['maptype'] = $params['maptype'] ?? 'roadmap'; $params['maptype'] = (!empty($params['maptype'])) ? $params['maptype'] : 'roadmap';
        $params['key'] = $params['key'] ?? GOOGLE_API_KEY; $params['key'] = (!empty($params['key'])) ? $params['key'] : GOOGLE_API_KEY;
        $url = 'https://maps.googleapis.com/maps/api/staticmap'.'?'.http_build_query($params);
        $file_content = file_get_contents($url);
        return $file_content;
    }

}