<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Fcm {

    function __construct() {
        $this->ci = & get_instance();
    }

    function send_push($params){
        $target = [];
        $params['title'] = $params['title'] ?? WEBSITE_TITLE;
        if(empty($params['title'])) $params['title'] = WEBSITE_TITLE;
        $params['msg'] = $params['msg'] ?? '';
        $params['type'] = $params['type'] ?? 'general';
        if(empty($params['type'])) $params['type'] = 'general';
        
        $params['adata'] = $params['adata'] ?? [];
        $params['device_token'] = $params['device_token'] ?? '';
        $params['device_type'] = $params['device_type'] ?? '';
        $params['is_silent'] = $params['is_silent'] ?? FALSE;
        $params['redirect_id'] = $params['redirect_id'] ?? '';

        if(empty($params['device_token']) && empty($params['device_type'])):
            return FALSE;
        endif;

        array_push($target, $params['device_token']);

        $url = 'https://fcm.googleapis.com/fcm/send';

        $notification_data = [];
        $notification_data['title'] = $params['title']; 
        $notification_data['ticker'] = $params['title']; 
        $notification_data['vibrate'] = 1;     
        $notification_data['sound'] = 1;  
        $notification_data['message'] = $params['msg']; 
        $notification_data['alert'] = $params['msg']; 
        $notification_data['type'] = $params['type']; 
        $notification_data['redirect_id'] = $params['redirect_id']; 
        $notification_data['additional_data'] = $params['adata'];
        
        $fields = array();   
        if($params['device_type'] == "I"){  
            $notification_data['body'] = $notification_data['message']; 
            $fields['content_available'] = TRUE;
            if($params['is_silent'] == TRUE){
                $fields['data'] = $notification_data;
            }else{
                $fields['notification'] = $notification_data;
            }
        }else{  
            $fields['data'] = $notification_data;
        }

        $fields['mutable_content'] = TRUE;
        $fields['delay_while_idle'] = TRUE;
        $fields['priority'] = "high";
        $fields['registration_ids'] = $target;
        $headers = array('Content-Type:application/json','Authorization:key='.FCM_SERVER_KEY);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if ($err):
            return FALSE;
        else:
            return json_decode($response,TRUE);
        endif;
    }

    function send_push_multiple($params){
        $target = [];
        $params['title'] = $params['title'] ?? WEBSITE_TITLE;
        if(empty($params['title'])) $params['title'] = WEBSITE_TITLE;
        $params['msg'] = $params['msg'] ?? '';
        $params['type'] = $params['type'] ?? 'general';
        if(empty($params['type'])) $params['type'] = 'general';
        
        $params['adata'] = $params['adata'] ?? [];
        $params['device_type'] = $params['device_type'] ?? '';
        $params['redirect_id'] = $params['redirect_id'] ?? '';
        $params['tokens'] = $params['tokens'] ?? '';
        if(empty($params['tokens']) && empty($params['device_type'])):
            return FALSE;
        endif;

        $target = $params['tokens'];
        $url = 'https://fcm.googleapis.com/fcm/send';

        $notification_data = [];
        $notification_data['title'] = $params['title']; 
        $notification_data['ticker'] = $params['title']; 
        $notification_data['vibrate'] = 1;     
        $notification_data['sound'] = 1;  
        $notification_data['message'] = $params['msg']; 
        $notification_data['alert'] = $params['msg']; 
        $notification_data['type'] = $params['type']; 
        $notification_data['redirect_id'] = $params['redirect_id']; 
        $notification_data['additional_data'] = $params['adata'];
        
        $fields = array();   
        if($params['device_type'] == "I"){  
            $fields['notification'] = $notification_data;
        }else{  
            $fields['data'] = $notification_data;
        }

        $fields['mutable_content'] = TRUE;
        $fields['delay_while_idle'] = TRUE;
        $fields['priority'] = "high";
        $fields['registration_ids'] = $target;
        $headers = array('Content-Type:application/json','Authorization:key='.FCM_SERVER_KEY);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if ($err):
            return FALSE;
        else:
            return json_decode($response,TRUE);
        endif;
    }
}