<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Datatable
{

    function __construct()
    {
        $this->ci = &get_instance();
    }

    function generate_datatable_data($params = [])
    {
        $this->adminRow = $this->ci->loginlib->getLoggedInData();
        $selected_permissions = $this->ci->role_model->getModulePermissions($this->adminRow['role_id']);

        $offset = $this->adminRow['set_offset'];
        $dynamic_data = [];
        $dynamic_data['offset'] = $offset;
        $dynamic_data['module_name_singular'] = singular($params['module']);
        $dynamic_data['module_name_plural'] = plural($params['module']);
        // $dynamic_data['module_slug'] = url_title(singular($params['module']), 'dash', true);
        $dynamic_data['module_slug'] = $params['module'];
        $dynamic_data['id_field'] = $params['primary_id'];
        $dynamic_data['modal'] = $params['modal'] ?? '';
        $dynamic_data['add_link'] = $params['add_link'] ?? '';
        $dynamic_data['edit_link'] = $params['edit_link'] ?? '';
        $dynamic_data['edit_modal'] = $params['edit_modal'] ?? '';
        $dynamic_data['view_link'] = $params['view_link'] ?? '';
        $dynamic_data['view_modal'] = $params['view_modal'] ?? '';
        $dynamic_data['modal_body_field'] = $params['modal_body_field'] ?? '';
        $dynamic_data['fancybox_modal'] = $params['fancybox_modal'] ?? '';
        $dynamic_data['delete_link'] = $params['delete_link'] ?? '';
        $dynamic_data['permission_link'] = $params['permission_link'] ?? '';
        // $dynamic_data['datatable_id'] = 'table_'.plural($dynamic_data['module_slug']);
        $dynamic_data['columns'] = $params['columns'];
        $dynamic_data['total_records'] = $params['total_records'];
        $dynamic_data['filtered_records'] = $params['filtered_records'];
        $dynamic_data['permissions'] = $selected_permissions;
        return $dynamic_data;
    }

    function get_datatable($list = [], $dynamic_data, $postdata)
    {
        $data_details = $dynamic_data['module_name_singular'] . ' details';
        $offset = $dynamic_data['offset'];
        $data = [];
        $singular_url_prefix = ADMIN_URL . $dynamic_data['module_slug'];
        $no = $postdata['start'];

        $permissions = $dynamic_data['permissions'];
        $view_auth = $this->ci->authlib->isAuthorizedLink($permissions, $dynamic_data['module_slug'], 'view');
        $edit_auth = $this->ci->authlib->isAuthorizedLink($permissions, $dynamic_data['module_slug'], 'edit');
        $delete_auth = $this->ci->authlib->isAuthorizedLink($permissions, $dynamic_data['module_slug'], 'delete');
        $permission_auth = $this->ci->authlib->isAuthorizedLink($permissions, $dynamic_data['module_slug'], 'permission');
        $active_status_auth = $this->ci->authlib->isAuthorizedLink($permissions, $dynamic_data['module_slug'], 'update-status');

        foreach ($list as $single_row) {
            $row = [];
            $no++;
            if (isset($dynamic_data['columns']) && count($dynamic_data['columns']) > 0) {
                foreach ($dynamic_data['columns'] as $column) {
                    $id_field = $single_row[$dynamic_data['id_field']];
                    $column['column'] = $column['column'] ?? '';
                    // echo $column['type']."--".$column['column']."<br>";
                    if ($column['type'] == 'checkbox') {
                        $checkbox_block = '';
                        $checkbox_block .= '<div class="checkb_main checkbox text-center">';
                        $checkbox_block .= '<input type="checkbox" id="md_checkbox_' . $no . '" class="" value="' . $id_field . '" />';
                        $checkbox_block .= '<label for="md_checkbox_' . $no . '" class="mb-0"></label>';
                        $checkbox_block .= '</div>';
                        // $row[] = $checkbox_block;
                        $row[$column['type']] = $checkbox_block;
                    } elseif ($column['type'] == 'counter') {
                        // $row[] = '<div class="text-right">'.$no.'</div>';
                        $row[$column['type']] = '<div class="text-right">' . $no . '</div>';
                    } elseif ($column['type'] == 'input' && $column['column'] == 'email') {
                        if (!empty($dynamic_data['view_link']) && $view_auth) {
                            $link = $singular_url_prefix . '/' . $dynamic_data['view_link'] . '/' . $id_field;
                            $row[$column['column']] = '<a href="' . $link . '">' . $single_row[$column['column']] . '</a>';
                        } else {
                            $row[$column['column']] = $single_row[$column['column']];
                        }
                    } elseif ($column['type'] == 'actions') {
                        $actionData = "";
                        if (!empty($dynamic_data['view_link']) && $view_auth) {
                            $link = $singular_url_prefix . '/' . $dynamic_data['view_link'] . '/' . $id_field;
                            $actionData .= '<a href="' . $link . '" data-placement="top" data-toggle="tooltip" data-original-title="View ' . $data_details . '" class="mr-2"><i class="fa fa-eye"></i></a>';
                        }
                        if (!empty($dynamic_data['edit_link']) && $edit_auth) {
                            $link = $singular_url_prefix . '/' . $dynamic_data['edit_link'] . '/' . $id_field;
                            $actionData .= '<a href="' . $link . '" data-placement="top" data-toggle="tooltip" data-original-title="Edit ' . $data_details . '" class="editlink mr-2"><i class="fa fa-pencil-alt"></i></a>';
                        }
                        if (!empty($dynamic_data['edit_modal']) && $edit_auth) {
                            $actionData .= '<a href="javascript:void(0)" data-placement="top" data-toggle="modal" title="Edit ' . $data_details . '" class="editModal mr-2" data-target="#edit-modal" data-id="' . $id_field . '" data-module="' . $dynamic_data['module_slug'] . '"><i class="fa fa-pencil-alt"></i></a>';
                        }
                        if (!empty($dynamic_data['delete_link']) && $delete_auth) {
                            $actionData .= '<a href="javascript:void(0);" data-placement="top" data-toggle="tooltip" data-original-title="Delete ' . $data_details . '" class="deletelink mr-2" data-id="' . $id_field . '" data-module="' . $dynamic_data['module_slug'] . '"><i class="fa fa-trash-alt"></i></a>';
                        }
                        if (!empty($dynamic_data['permission_link']) && $permission_auth) {
                            /* $link = $singular_url_prefix.'/'.$dynamic_data['permission_link'].'/'.$id_field;
                            $actionData .= '<a href="'.$link.'" data-placement="top" data-toggle="tooltip" data-original-title="Permissions '.$data_details.'" class="mr-2" data-id="'.$id_field.'" data-module="'.$dynamic_data['module_slug'].'"><i class="fa fa-key"></i></a>'; */
                            $actionData .= '<a href="javascript:void(0)" data-placement="top" data-toggle="modal" title="Permissions ' . $data_details . '" class="permissionModal mr-2" data-target="#permission-modal" data-id="' . $id_field . '" data-module="' . $dynamic_data['module_slug'] . '"><i class="fa fa-key"></i></a>';
                        }
                        if (empty($actionData)) {
                            $actionData = '-';
                        }
                        // $row[] = '<div class="text-center table-actions">'.$actionData.'</div>';
                        $row[$column['type']] = '<div class="text-center table-actions">' . $actionData . '</div>';
                    } elseif ($column['type'] == 'image') {
                        $image_url = getFilePath($single_row[$column['column']]);
                        $image_block = '';
                        $image_block .= '<div class="text-center">';
                        $image_block .= '<a class="fancybox image_url" href="' . $image_url . '" />';
                        $image_block .= '<img src="' . $image_url . '" width="50" />';
                        $image_block .= '</a>';
                        $image_block .= '</div>';
                        // $row[] = $image_block;
                        $row[$column['column']] = $image_block;
                    } elseif ($column['type'] == 'video') {
                        $thumbnail_url = getFilePath($single_row[$column['thumbnail']]);
                        $video_url = getFilePath($single_row[$column['column']]);
                        $video_block = '';
                        $video_block .= '<span>';
                        $video_block .= '<a class="fancybox video_url" href="' . $video_url . '" />';
                        $video_block .= '<img src="' . $thumbnail_url . '" width="50" />';
                        $video_block .= '</a>';
                        $video_block .= '</span>';
                        // $row[] = $video_block;
                        $row[$column['column']] = $video_block;
                    } elseif ($column['type'] == 'select') {
                        if ($column['column'] == 'is_active') {
                            if ($active_status_auth) {
                                $val = ($single_row[$column['column']]) ? 'Active' : 'Inactive';
                                $status = ($single_row[$column['column']]) ? 0 : 1;
                                $btnstart = '<a href="javascript:void(0)" class="statusmgt" data-module="' . $dynamic_data['module_slug'] . '" data-id="' . $id_field . '" data-value="' . $val . '" data-status="' . $status . '">';
                                $btnend = '</a>';
                                if ($single_row[$column['column']]) :
                                    // $row[] = '<div class="d-block text-center"><span class="badge badge-success badge-theme-success">'.$btnstart.'Active'.$btnend.'</span></div>';
                                    $row[$column['column']] = '<div class="d-block text-center"><span class="badge badge-success badge-theme-success">' . $btnstart . 'Active' . $btnend . '</span></div>';
                                else :
                                    // $row[] = '<div class="d-block text-center"><span class="badge badge-danger badge-theme-cancel">'.$btnstart.'Inactive'.$btnend.'</span></div>';
                                    $row[$column['column']] = '<div class="d-block text-center"><span class="badge badge-danger badge-theme-cancel">' . $btnstart . 'Inactive' . $btnend . '</span></div>';
                                endif;
                            } else {
                                if ($single_row[$column['column']]) :
                                    // $row[] = 'Active';
                                    $row[$column['column']] = 'Active';
                                else :
                                    // $row[] = 'Inactive';
                                    $row[$column['column']] = 'Inactive';
                                endif;
                            }
                        } elseif ($column['column'] == 'premium') {
                            if ($active_status_auth) {
                                $val = ($single_row[$column['column']]) ? 'Yes' : 'No';
                                $status = ($single_row[$column['column']]) ? 0 : 1;
                                $btnstart = '<a href="javascript:void(0)" class="premiummgt" data-module="' . $dynamic_data['module_slug'] . '" data-id="' . $id_field . '" data-value="' . $val . '" data-status="' . $status . '">';
                                $btnend = '</a>';
                                if ($single_row[$column['column']]) :
                                    $row[$column['column']] = '<div class="d-block text-center"><span class="badge badge-success badge-theme-success">' . $btnstart . 'Yes' . $btnend . '</span></div>';
                                else :
                                    $row[$column['column']] = '<div class="d-block text-center"><span class="badge badge-danger badge-theme-cancel">' . $btnstart . 'No' . $btnend . '</span></div>';
                                endif;
                            } else {
                                if ($single_row[$column['column']]) :
                                    $row[$column['column']] = 'Yes';
                                else :
                                    $row[$column['column']] = 'No';
                                endif;
                            }
                        } elseif ($column['column'] == 'recommend') {
                            if ($active_status_auth) {
                                $val = ($single_row[$column['column']]) ? 'Yes' : 'No';
                                $status = ($single_row[$column['column']]) ? 0 : 1;
                                $btnstart = '<a href="javascript:void(0)" class="recommendmgt" data-module="' . $dynamic_data['module_slug'] . '" data-id="' . $id_field . '" data-value="' . $val . '" data-status="' . $status . '">';
                                $btnend = '</a>';
                                if ($single_row[$column['column']]) :
                                    $row[$column['column']] = '<div class="d-block text-center"><span class="badge badge-success badge-theme-success">' . $btnstart . 'Yes' . $btnend . '</span></div>';
                                else :
                                    $row[$column['column']] = '<div class="d-block text-center"><span class="badge badge-danger badge-theme-cancel">' . $btnstart . 'No' . $btnend . '</span></div>';
                                endif;
                            } else {
                                if ($single_row[$column['column']]) :
                                    $row[$column['column']] = 'Yes';
                                else :
                                    $row[$column['column']] = 'No';
                                endif;
                            }
                        } elseif ($column['column'] == 'question_type') {
                            // $row[] = ucfirst($single_row[$column['column']]);
                            $row[$column['column']] = ucfirst($single_row[$column['column']]);
                        } elseif ($column['column'] == 'is_expired') {
                            if ($single_row[$column['column']]) {
                                $row[$column['column']] = '<div class="d-block text-center"><span class="badge badge-danger badge-theme-danger">Expired</span></div>';
                            } elseif (!is_null($single_row[$column['column']])) {
                                $row[$column['column']] = '<div class="d-block text-center"><span class="badge badge-success badge-theme-success">Active</span></div>';
                            } else {
                                $row[$column['column']] = '<div class="d-block text-center">-</div>';
                            }
                        } elseif ($column['column'] == 'is_trial_period') {
                            if (!is_null($single_row[$column['column']])) {
                                $row[$column['column']] = '<div class="d-block text-center"><span class="badge bg-orange">' . (($single_row[$column['column']]) ? 'Yes' : 'No') . '</span></div>';
                            } else {
                                $row[$column['column']] = '<div class="d-block text-center">-</div>';
                            }
                        } elseif ($column['column'] == 'is_deleted') {
                            if ($single_row[$column['column']]) {
                                $row[$column['column']] = '<div class="d-block text-center"><span class="badge bg-danger">Yes</span></div>';
                            } else {
                                $row[$column['column']] = '<div class="d-block text-center"><span class="badge bg-success">No</span></div>';
                            }
                        } elseif ($column['column'] == 'email_verification_status') {
                            if (!is_null($single_row[$column['column']])) {
                                if ($single_row[$column['column']]) {
                                    $row[$column['column']] = '<div class="d-block text-center"><span class="badge bg-success">Yes</span></div>';
                                } else {
                                    $row[$column['column']] = '<div class="d-block text-center"><span class="badge bg-danger">No</span></div>';
                                }
                            } else {
                                $row[$column['column']] = '<div class="d-block text-center">-</div>';
                            }
                        } else {
                            // $row[] = $single_row[$column['column']];
                            $row[$column['column']] = $single_row[$column['column']];
                        }
                    } elseif ($column['type'] == 'daterange') {
                        if (in_array($column['column'], ['original_purchase_date_ms', 'purchase_date_ms', 'expires_date_ms'])) :
                            if (!is_null($single_row[$column['column']])) {
                                $single_row[$column['column']] /= 1000;
                                $row[$column['column']] = '<div class="text-center">' . date(DATETIME_FORMAT, $single_row[$column['column']] + $offset) . '</div>';
                            } else {
                                $row[$column['column']] = '<div class="text-center">-</div>';
                            }
                        elseif (in_array($column['column'], ['created_date', 'updated_date', 'stat_date'])) :
                            if (!is_null($single_row[$column['column']])) {
                                $row[$column['column']] = '<div class="text-center">' . date(DATETIME_FORMAT, strtotime($single_row[$column['column']])) . '</div>';
                            } else {
                                $row[$column['column']] = '<div class="text-center">-</div>';
                            }
                        else :
                            $row[$column['column']] = '<div class="text-center">' . date(DATETIME_FORMAT, $single_row[$column['column']] + $offset) . '</div>';
                        endif;
                    } elseif ($column['type'] == 'validrange') {
                        if ($column['column'] == 'banner_valid_range') :
                            // $row[] = '<div class="text-center">'.date(DATE_FORMAT,$single_row['banner_valid_from'] + $offset).' - '.date(DATE_FORMAT,$single_row['banner_expire_at'] + $offset).'</div>';
                            $row[$column['column']] = '<div class="text-center">' . date(DATE_FORMAT, $single_row['banner_valid_from'] + $offset) . ' - ' . date(DATE_FORMAT, $single_row['banner_expire_at'] + $offset) . '</div>';
                        else :
                            // $row[] = '<div class="text-center">'.date(DATE_FORMAT,$single_row['valid_from'] + $offset).' - '.date(DATE_FORMAT,$single_row['expire_at'] + $offset).'</div>';
                            $row[$column['column']] = '<div class="text-center">' . date(DATE_FORMAT, $single_row['valid_from'] + $offset) . ' - ' . date(DATE_FORMAT, $single_row['expire_at'] + $offset) . '</div>';
                        endif;
                    } elseif ($column['type'] == 'ratings') {
                        $str = '<div class="text-center">' . print_ratings($single_row[$column['column']]) . '</div>';
                        // $row[] = $str;
                        $row[$column['column']] = $str;
                    } else {
                        // $row[] = $single_row[$column['column']];
                        $row[$column['column']] = $single_row[$column['column']];
                    }
                }
            }
            $data[] = $row;
        }

        $output = array(
            "draw" => $postdata['draw'],
            "recordsTotal" => $dynamic_data['total_records'],
            "recordsFiltered" => $dynamic_data['filtered_records'],
            "data" => $data,
        );
        echo json_encode($output);
    }
}
