
<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Administrator extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        if(DEBUG_MODE) { $this->output->enable_profiler(TRUE); }
        $this->load->library(['loginlib','datatable']);
        $this->data = [];
        $this->checkIfLoggedIn();
        $this->data['loggedIn'] = $this->loginlib->getLoggedInData();
        $selected_permissions = $this->role_model->getModulePermissions($this->data['loggedIn']['role_id']);
        $this->data['permissions'] = $selected_permissions;
        // echo '<pre>';print_r($selected_permissions);die;
        $controller = str_replace('_','-',$this->router->fetch_class());
        if(!in_array($controller, DEFAULT_CONTROLLERS)){
            $this->authlib->isAuthorized($this->data['permissions']);
        }
        $this->data['module'] = $controller;
        $this->data['module_title'] = ucwords(plural(humanize($controller,'-')));
        $this->data['singular_title'] = ucwords(singular(humanize($controller,'-')));
    }

    private function checkIfLoggedIn(){
        if(!$this->session->userdata('admin_id')){
            if(isset($_SERVER['REDIRECT_QUERY_STRING']) && !empty($_SERVER['REDIRECT_QUERY_STRING'])){
                $redirectlink = str_replace('/'.ADMIN_SITENAME.'/','',$_SERVER['REDIRECT_QUERY_STRING']);
                $this->session->set_flashdata('redirect-link', $redirectlink);
            }
            redirect(ADMIN_URL.'login');
        }
    }
}