<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Reset_password extends Guest
{
    public function __construct(){
        parent::__construct();
        $this->data = [];
    }

    public function recover($token = ''){
        if(empty($token)){
            show_404();
        }
        $tokenwhere = ['password_token'=>$token,'token_validity >= '=>time()];
        $tokenData =  $this->login_model->getPasswordTokenDetails($tokenwhere);
        if(!$tokenData){
            show_404();
        }
        $this->data['page_title'] = 'Reset Password';
        $this->data['forms'] = [
            'frm_reset_password' => ['id' => 'frm_reset_password', 'method' => 'POST'],
        ];
        $this->data['form_rules'] = [
            'frm_reset_password' => [
                'new_password' => ['required' => true, 'minlength' => 6],
                'confirm_password' => ['required' => true, 'minlength' => 6, 'equalTo' => '#new_password'],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_reset_password' => [
                'ajax_url' => ADMIN_GUEST_AJAX_URL.'reset-password',
                'redirect_url' => ADMIN_URL.'login',
            ],
        ];
        $this->load->admin_guest_template('reset-password',$this->data);
    }
}