<?php
defined('BASEPATH') or exit('No direct script access allowed');
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Question extends Administrator
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $module = $this->data['module'];
        $this->data['page_title'] = $this->data['module_title'];
        $this->data['breadcrumb'] = [
            ['title' => 'Home', 'url' => ADMIN_URL],
            ['title' => $this->data['module_title'], 'url' => ADMIN_URL . $module],
            ['title' => 'List', 'url' => ''],
        ];
        $this->data['datatable_url'] = ADMIN_AJAX_URL.'get-'.$module.'-list';
        $categories = $this->category_model->getRecords();
        $this->data['categories'] = $categories;
        $category_options = [];
        foreach ($this->data['categories'] as $cat):
            $category_options[$cat['category_id']] = $cat['category_label'];
        endforeach;

        $this->data['columns'] = [
            ['type' => 'checkbox'],
            ['type' => 'counter'],
            ['type' => 'select', 'has_filter' => TRUE, 'id' => 'question_category_id', 'label' => 'Question Category', 'options'=> $category_options, 'list_params' => ['width' => '15%','data-visible' => 'false']],
            ['type' => 'input', 'has_filter' => FALSE, 'id' => 'category_label', 'label' => 'Question Category', 'list_params' => ['width' => '15%']],
            ['type' => 'input', 'has_filter' => TRUE, 'id' => 'question', 'label' => 'Question', 'list_params' => ['width' => '15%']],
            ['type' => 'select', 'has_filter' => TRUE, 'id' => 'question_type', 'label' => 'Question Type', 'options' => ['truth' => 'Truth', 'dare' => 'Dare'], 'list_params' => ['width' => '8%']],
            ['type' => 'select', 'has_filter' => TRUE, 'id' => 'is_active', 'label' => 'Status', 'options' => ACTIVE_INACTIVE_OPTIONS, 'list_params' => ['width' => '8%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'created_at', 'label' => 'Created at', 'list_params' => ['width' => '8%']],
            ['type' => 'actions', 'has_filter' => FALSE, 'label' => 'Action', 'list_params' => ['width' => '5%', 'class' => 'action-column', 'data-orderable' => 'false', 'data-searchable' => 'false']],
        ];
        $this->data['forms'] = [
            'frm_add' => ['id' => 'frm_add', 'method' => 'POST'],
            'frm_edit' => ['id' => 'frm_edit', 'method' => 'POST'],
            'frm_import' => ['id' => 'frm_import', 'method' => 'POST'],
        ];
        $this->data['form_rules'] = [
            'frm_add' => [
                'question_category_id' => ['required' => true],
                'question' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'question_type' => ['required' => true],
                'is_active' => ['required' => true],
            ],
            'frm_edit' => [
                'question_category_id' => ['required' => true],
                'question' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'question_type' => ['required' => true],
                'is_active' => ['required' => true],
            ],
            'frm_import' => [
                'import' => ['required' => true, 'extension' => 'xls|xlsx'],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_add' => [
                'ajax_url' => ADMIN_AJAX_URL . 'add-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
            'frm_edit' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
            'frm_import' => [
                'ajax_url' => ADMIN_AJAX_URL . 'import-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
        ];
        $this->data['form_filter'] = [
            'id' => 'frm_filter',
            'class' => 'frm_filter',
            'fields' => [
                'question_category_id' => [
                    'class' => 'form-control',
                    'name' => 'question_category_id', 'id' => 'question_category_id',
                    'style' => 'display: none',
                ],
                'question' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'question', 'id' => 'question', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'question_type' => [
                    'class' => 'form-control',
                    'name' => 'question_type', 'id' => 'question_type',
                    'style' => 'display: none',
                ],
                'is_active' => [
                    'class' => 'form-control',
                    'name' => 'is_active', 'id' => 'is_active',
                    'style' => 'display: none',
                ],
                'created_at' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'created_at', 'id' => 'created_at', 'placeholder' => 'Select datetime range',
                    'style' => 'display: none',
                ],
            ]
        ];
        $this->data['sample_url'] = ADMIN_URL.$module.'/download-sample';
        $this->load->admin_auth_template($module.'/list', $this->data);
    }

    /* public function edit($id)
    {
        $row = $this->question_model->getRow($id);
        if (!$row) {
            show_404();
        }
        $module = $this->data['module'];
        $this->data['page_title'] = 'Update '.$this->data['singular_title'];
        $this->data['breadcrumb'] = [
            ['title' => 'Home', 'url' => ADMIN_URL],
            ['title' => $this->data['module_title'], 'url' => ADMIN_URL . $module],
            ['title' => 'Update', 'url' => ''],
        ];
        $this->data['forms'] = [
            'frm_edit' => ['id' => 'frm_edit', 'method' => 'POST'],
        ];
        $this->data['form_rules'] = [
            'frm_edit' => [
                'question_category_id' => ['required' => true],
                'question' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'question_type' => ['required' => true],
                'is_active' => ['required' => true],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_edit' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
        ];
        $categories = $this->category_model->getRecords();
        $this->data['categories'] = $categories;
        $this->data['row'] = $row;
        $this->load->admin_auth_template($module.'/edit', $this->data);
    } */

    public function download_sample(){
        $module = $this->data['module'];
        $spreadsheet = new Spreadsheet();
        $spreadsheet->setActiveSheetIndex(0)
            ->setCellValue('A1', '#')
            ->setCellValue('B1', 'Question')
            ->setCellValue('C1', 'Type')
            ->setCellValue('D1', 'Category');

        $truth_questions = [
            'When Was The Last Time You Told A Lie?',
            'What Was Your First Kiss Like?',
            'What Is Your Least Favorite Thing About Your Best Friend?',
            'Have You Ever Committed A Crime? If So, What Was It?',
            'Have You Ever Cried From Watching A TV Show Or A Movie?',
            'What Would You Do With A Million Dollars?',
            'What Is The Most Embarrassing Thing That Your Parents Have Caught You Doing?',
            'When Was A Time That You Completely Lost It?',
            'If You Could Have Someone Else’s Life For One Day, Who Would It Be?',
            'If You Could Say Anything To One Person In Your Life Without Any Consequences, What Would It Be?',
        ];
        $dare_questions = [
            'Talk About A Time That You Failed In Life.',
            'Name One Thing On Your Bucket List.',
            'Reveal The Contents Of Your Purse/Wallet.',
            'Pick One Person In The Group, What Is Some Honest Relationship Advice You Would Give Them?',
            'Tell Every Detail Of The Last Dream You Had And Don’t Leave Anything Out.',
            'Tell Us About Your Five Bad Habits.',
            'Express Your Feelings For Your Siblings.',
            'Describe Your First Date.',
            'Tell Us The Best Quality And One Negative Point In Your Partner.',
            'Arrange Them In Descending Order Of Importance – Money, Love, Family, Career, Friends.',
        ];
        $dataArray = [];
        $categories = $this->category_model->getRecords();
        if(!empty($categories) && count($categories) > 0){
            $no = 1;
            foreach($categories as $cat){
                $dataArray[] = [
                    $no++, $truth_questions[rand(0,count($truth_questions)-1)], 'Truth', $cat['category_label']
                ];
                $dataArray[] = [
                    $no++, $dare_questions[rand(0,count($dare_questions)-1)], 'Dare', $cat['category_label']
                ];
            }
        }

        $spreadsheet->setActiveSheetIndex(0)->fromArray($dataArray, null, 'A2');
        $spreadsheet->setActiveSheetIndex(0)->getStyle('A1:D1')->getFont()->setBold(true);
        $spreadsheet->setActiveSheetIndex(0)->setAutoFilter($spreadsheet->setActiveSheetIndex(0)->calculateWorksheetDimension());
        $spreadsheet->setActiveSheetIndex(0);

        $writer = new Xlsx($spreadsheet);
        $filename = $module.'-sample.xlsx';
        $filefullpath = SITE_PATH.IMPORT_PATH.$filename;
        $writer->save($filefullpath);
        redirect(SITE_URL.IMPORT_PATH.$filename);
    }
}
