<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Guest_user extends Administrator
{
    public function __construct(){
        parent::__construct();
    }

    public function index($params = []){
        // $this->guest_user_model->getDatatableList([]);
        // showQuery();
        $params['get_latest'] = $params['get_latest'] ?? FALSE;
        $module = $this->data['module'];
        $this->data['page_title'] = $params['page_title'] ?? $this->data['module_title'];
        $this->data['breadcrumb'] = [
            ['title'=>'Home','url'=>ADMIN_URL],
            ['title'=>$this->data['module_title'],'url'=>ADMIN_URL . $module],
            ['title'=>'List','url'=>''],
        ];
        $this->data['datatable_url'] = ADMIN_AJAX_URL . 'get-'.$module.'-list'.(($params['get_latest']) ? '/true' : '');
        $this->data['columns'] = [
            // ['type' => 'checkbox'],
            ['type' => 'counter'],
            ['type' => 'input', 'has_filter' => TRUE, 'id' => 'wholesaler_user', 'label' => 'Wholesaler User', 'list_params' => ['width' => '15%']],
            ['type' => 'input', 'has_filter' => TRUE, 'id' => 'device_unique_id', 'label' => 'Device ID', 'list_params' => ['width' => '15%']],
            ['type' => 'input', 'has_filter' => TRUE, 'id' => 'device_name', 'label' => 'Device Name', 'list_params' => ['width' => '15%']],
            ['type' => 'input', 'has_filter' => TRUE, 'id' => 'product_id', 'label' => 'Subscription', 'list_params' => ['width' => '15%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'original_purchase_date_ms', 'label' => 'Initial Purchased at', 'list_params' => ['width' => '8%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'purchase_date_ms', 'label' => 'Purchased at', 'list_params' => ['width' => '8%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'expires_date_ms', 'label' => 'Expires at', 'list_params' => ['width' => '8%']],
            ['type' => 'select', 'has_filter' => TRUE, 'id' => 'is_trial_period', 'label' => 'Trial Subscription', 'options' => YES_NO_OPTIONS, 'list_params' => ['width' => '8%']],
            ['type' => 'select', 'has_filter' => TRUE, 'id' => 'is_expired', 'label' => 'Subscription Status', 'options' => IS_EXPIRED_OPTIONS, 'list_params' => ['width' => '8%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'created_at', 'label' => 'Created at', 'list_params' => ['width' => '8%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'updated_at', 'label' => 'Last Seen', 'list_params' => ['width' => '8%']],
            ['type' => 'actions', 'has_filter' => FALSE, 'label' => 'Action', 'list_params' => ['width' => '5%', 'class' => 'action-column', 'data-orderable' => 'false', 'data-searchable' => 'false']],
        ];
        $this->data['forms'] = [
            // 'frm_add' => ['id' => 'frm_add', 'method' => 'POST'],
            // 'frm_edit' => ['id' => 'frm_edit', 'method' => 'POST'],
        ];
        $this->data['form_rules'] = [
            /* 'frm_add' => [
                'category_label' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'is_active' => ['required' => true],
            ],
            'frm_edit' => [
                'category_label' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'is_active' => ['required' => true],
            ], */
        ];
        $this->data['form_ajax'] = [
            /* 'frm_add' => [
                'ajax_url' => ADMIN_AJAX_URL . 'add-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
            'frm_edit' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ], */
        ];
        $this->data['form_filter'] = [
            'id' => 'frm_filter',
            'class' => 'frm_filter',
            'fields' => [
                'wholesaler_user' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'wholesaler_user', 'id' => 'wholesaler_user', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'device_unique_id' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'device_unique_id', 'id' => 'device_unique_id', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'device_name' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'device_name', 'id' => 'device_name', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'product_id' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'product_id', 'id' => 'product_id', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'original_purchase_date_ms' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'original_purchase_date_ms', 'id' => 'original_purchase_date_ms', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'purchase_date_ms' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'purchase_date_ms', 'id' => 'purchase_date_ms', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'expires_date_ms' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'expires_date_ms', 'id' => 'expires_date_ms', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'is_trial_period' => [
                    'class' => 'form-control',
                    'name' => 'is_trial_period', 'id' => 'is_trial_period',
                    'style' => 'display: none',
                ],
                'is_expired' => [
                    'class' => 'form-control',
                    'name' => 'is_expired', 'id' => 'is_expired',
                    'style' => 'display: none',
                ],
                'is_active' => [
                    'class' => 'form-control',
                    'name' => 'is_active', 'id' => 'is_active',
                    'style' => 'display: none',
                ],
                'created_at' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'created_at', 'id' => 'created_at', 'placeholder' => 'Select datetime range',
                    'style' => 'display: none',
                ],
                'updated_at' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'updated_at', 'id' => 'updated_at', 'placeholder' => 'Select datetime range',
                    'style' => 'display: none',
                ],
            ],
        ];
        $this->load->admin_auth_template($module.'/list', $this->data);
    }

    public function latest(){
        $params = [
            'get_latest' => TRUE,
            'page_title' => 'Latest Users'
        ];
        $this->index($params); // Get Latest Data
    }

    public function view($id = NULL){
        if(!$id){ show_custom_404(); }
        $user = $this->guest_user_model->getRow($id);
        if(!$user){ show_custom_404(); }

        $module = $this->data['module'];
        $this->data['page_title'] = singular($this->data['module_title']);
        $this->data['breadcrumb'] = [
            ['title'=>'Home','url'=>ADMIN_URL],
            ['title'=>$this->data['module_title'],'url'=>ADMIN_URL . $module],
            ['title'=>'View','url'=>''],
        ];
        $where = ['device.user_device_id' => $id];
        $params = [
            'where' => $where,
            'order'=>[['order'=>'web_subscription.created_at','type'=>'DESC'],['order'=>'web_subscription.webhook_subscription_id','type'=>'DESC']]
        ];
        $transactions = $this->guest_user_model->getAllTransactions($params);
        $this->data['user'] = $user;
        $deviceParams = [
            'where'=>['device.user_device_id'=>$id],
            'order' => ['order'=>'device.created_at','type'=>'DESC'],
            'action' => 'row'
        ];
        $this->data['device'] = $this->guest_user_model->getDeviceDetails($deviceParams);
        $this->data['transactions'] = $transactions;
        $authRevenueWhere = ['web_subscription.is_trial_period' => 0,'usubscription.user_id' => NULL,'usubscription.user_device_id' => $id];
        $this->data['total_spent'] = $this->user_model->totalRevenue(['action'=>'row','where' => $authRevenueWhere])['total'] ?? 0;
        $this->load->admin_auth_template($module.'/view', $this->data);
    }
}