<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Guest_ajax extends Guest
{
    public function __construct(){
        parent::__construct();
        $this->data = [];
    }

    public function check_login(){
        $rules = [
            'email' => [
                'field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email',
            ],
            'password' => [
                'field' => 'password', 'label' => 'Password', 'rules' => 'required|trim|min_length[6]',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();

        $admin = $this->login_model->checkIfAdminDetailExist($postdata['email']);
        if(!$admin){
            sendResponse(false, 'Email address does not exist');
        }
        $verifyFlag = password_verify($postdata['password'],$admin['admin_password']);
        if(!$verifyFlag){
            sendResponse(false, 'Invalid login credentials given');
        }
        if(!$admin['is_active']){
            sendResponse(false, 'Your account is inactive. Please contact administrator');
        }
        $this->loginlib->set_session($admin,$postdata['timezone'] ?? '',$postdata['timezone_offset'] ?? 0);
        $adminRow = $this->login_model->getLoggedInAdminData(['admin_email'=>$postdata['email']]);
        $msg = 'Logged In successfully!';
        $this->session->set_flashdata('success',$msg);
        sendResponse(true, $msg, $adminRow);
    }

    private function send_reset_password_link($admin){
        // $code = $this->api_model->getPasswordResetToken($user['user_id']);
        $code = $this->login_model->generatePasswordToken($admin['admin_id']);
        $reset_password_link = ADMIN_URL.'reset-password/recover/'.$code['password_token'];
        $email_params = [
            'fullname' => 'Admin',
            'reset_password_link' => $reset_password_link,
            'email' => $code['admin_email']
        ];
        $this->sendmail->admin_reset_password($email_params);
    }

    public function generate_password_token(){
        $rules = [
            'email' => [
                'field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();

        $admin = $this->login_model->checkIfAdminDetailExist($postdata['email']);
        if(!$admin){
            sendResponse(false, 'Email address does not exist');
        }
        /* $tokenData = $this->login_model->generatePasswordToken($admin['admin_id']);
        pre($tokenData);
        if(!$tokenData){
            sendResponse(false, SYSTEM_ERROR);
        } */
        $this->send_reset_password_link($admin);
        $msg = 'We have sent a link to your registered email address to reset password.';
        $this->session->set_flashdata('success',$msg);
        sendResponse(true, $msg);
    }

    public function reset_password(){
        $rules = [
            'token' => [
                'field' => 'token', 'label' => 'Password Token', 'rules' => 'required|exact_length[15]',
            ],
            'new_password' => [
                'field' => 'new_password', 'label' => 'New Password', 'rules' => 'required|min_length[6]',
            ],
            'confirm_password' => [
                'field' => 'confirm_password', 'label' => 'Email', 'rules' => 'required|min_length[6]|matches[new_password]',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $tokenwhere = ['password_token'=>$postdata['token'],'token_validity >= '=>time()];
        $row =  $this->login_model->getPasswordTokenDetails($tokenwhere);
        if(!$row){
            show_404();
        }
        if (password_verify($postdata['new_password'], $row['admin_password'])):
            $msg = 'Old & new password cannot be same';
            $this->session->set_flashdata('error', $msg);
            sendResponse(false, $msg);
        else:
            $flag = $this->profile_model->updatePassword($postdata['new_password'], $row['admin_id']);
            if($flag === FALSE):
                sendResponse(false, SYSTEM_ERROR);
            endif;
            $this->profile_model->deletePasswordTokens($row['admin_id'], $postdata['token']);
            $msg = 'Password reset successfully';
            $this->session->set_flashdata('success', $msg);
            sendResponse(true, $msg);
        endif;
    }
    
}