<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Webhook extends CI_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('webhook_model');
        $this->load->library('vpn');
    }

    function str_lreplace($search, $replace, $subject) {
        $pos = strrpos($subject, $search);
        if($pos !== false) {
            $subject = substr_replace($subject, $replace, $pos, strlen($search));
        }
        return $subject;
    }

    public function amazon(){
        $obj = json_decode($this->input->raw_input_stream, true);
        mylog("Amazon subscription captured => ".$this->input->raw_input_stream);
        $this->validate_and_store_webhook_data_amazon($obj);
    }

    public function capture(){
        $find = ',';
        $replace = '';
        // foreach (glob('/home/admin-pc/Downloads/ios-webhook-log-07/*-copy.log') as $file) {
        foreach (glob('/home/admin-pc/Downloads/ios-webhooks/08-2021/*.log') as $file) {
            $this->input->raw_input_stream = '';
            if (is_file($file)) {
                $file_content = file_get_contents($file);
                $file_content = str_replace('----------------------------------------------------------------------------------------------------',',',$file_content);
                $file_content = $this->str_lreplace($find, $replace, $file_content);
                $file_content = '['.$file_content.']';
                $notifications = json_decode($file_content, true);
                foreach($notifications as $notify){
                    $this->input->raw_input_stream = json_encode($notify);
                    $this->notify();
                }
            }
        }
    }

    // Apple
    public function notify(){
        $obj = json_decode($this->input->raw_input_stream, true);
        $this->validate_and_store_webhook_data($obj);
    }

    // Apple
    public function notify_v2(){
        $obj = json_decode($this->input->raw_input_stream, true);
        mylog("v2 Webhook received");
        mylog($this->input->raw_input_stream);
        $this->validate_and_store_v2_webhook_data($obj);
    }

    public function notify_amazon(){
        $obj = json_decode($this->input->raw_input_stream, true);
        mylog("Amazon subscription captured => ".$this->input->raw_input_stream);
        $this->validate_and_store_webhook_data_amazon($obj);
    }

    // Huawei
    public function notify_huawei()
    {
        $obj = json_decode($this->input->raw_input_stream, true);
        mylog("huawei v2 Webhook received");
        mylog($this->input->raw_input_stream);
        $this->validate_and_store_huawei_v2_webhook_data($obj);
    }

     // Huawei
     private function get_huawei_store_price($product_id, $notification_type)
     {
         if (in_array($notification_type, HUAWEI_PRICING_NOTIFICATION_STATUS)) {
             return HUAWEI_SUBSCRIPTION_PACKAGE_LIST[$product_id];
         }
         return 0;
     }
 
     // Huawei
     private function get_expiration_intent_info_huawei($key)
     {
         $expiration_intents = [
             '1' => "The customer voluntarily canceled their subscription.",
             '2' => "The product was not available for purchase at the time of renewal.",
             '3' => "Abnormal user signing information was detected during the renewal process.",
             '4' => "Billing error; for example, the customer's payment information was no longer valid.",
             '5' => "The customer did not agree to a recent price increase.",
             '6' => "Unknown error."
         ];
         if (array_key_exists($key, $expiration_intents)) {
             return $expiration_intents[$key];
         } else {
             return '';
         }
     }
 
     // Huawei
     private function get_notification_type_huawei($notificationType)
     {
         switch ($notificationType) {
             case '0':
                 $notification_type  = 'INITIAL_BUY';
                 break;
             case '1':
                 $notification_type  = 'CANCEL';
                 break;
             case '2':
                 $notification_type  = 'RENEWAL';
                 break;
             case '3':
                 $notification_type  = 'INTERACTIVE_RENEWAL';
                 break;
             case '4':
                 $notification_type  = 'NEW_RENEWAL_PREF';
                 break;
             case '5':
                 $notification_type  = 'RENEWAL_STOPPED';
                 break;
             case '6':
                 $notification_type  = 'RENEWAL_RESTORED';
                 break;
             case '7':
                 $notification_type  = 'RENEWAL_RECURRING';
                 break;
             default:
                 break;
         }
         return $notification_type;
     }

     // Huawei V2
     private function validate_and_store_huawei_v2_webhook_data($obj)
     {
         $json = $obj['subNotification']['statusUpdateNotification'];
         $obj = json_decode($json, true);
         $latestReceiptInfo = json_decode($obj['latestReceiptInfo'], true);
         $transaction = [
             'notification_store' => APP_STORE_HUAWEI,
             'notification_type' => $this->get_notification_type_huawei($obj['notificationType']),
             'environment' => $obj['environment'],
             'auto_renew_product_id' => $latestReceiptInfo['productId'],
             'auto_renew_status' => $obj['autoRenewStatus'],
             'auto_renew_status_change_date_ms' =>  time(),
             'password' => '',
             'bid' => '',
             'bvrs' => '',
             'latest_receipt' => $obj['latestReceipt'],
             'in_app_ownership_type' => 'PURCHASED',
             'purchase_date_ms' => $latestReceiptInfo['purchaseTime'],
             'original_purchase_date_ms' => $latestReceiptInfo['purchaseTime'],
             'transaction_id' => $obj['subscriptionId'],
             'original_transaction_id' => $obj['orderId'],
             'quantity' => $latestReceiptInfo['quantity'],
             'expires_date_ms' => $latestReceiptInfo['expirationDate'],
             'product_id' => $latestReceiptInfo['productId'],
             'is_trial_period' => $latestReceiptInfo['trialFlag'],
             'is_in_intro_offer_period' => $latestReceiptInfo['introductoryFlag'],
             'expiration_intent' => $this->get_expiration_intent_info_huawei($obj['expirationIntent'] ?? ''),
             'cancellation_date_ms' => $latestReceiptInfo['cancellationTime'] ?? 0,
             'price' => $this->get_huawei_store_price($latestReceiptInfo['productId'], $obj['notificationType']),
         ];
         $this->store_transaction_details($transaction);
     }

    // Apple
    private function get_expiration_intent_info($key){
        $expiration_intents = [
            '1' => "The customer voluntarily canceled their subscription.",
            '2' => "Billing error; for example, the customer's payment information was no longer valid.",
            '3' => "The customer did not agree to a recent price increase.",
            '4' => "The product was not available for purchase at the time of renewal.",
            '5' => "Unknown error."
        ];
        if(array_key_exists($key, $expiration_intents)){
            return $expiration_intents[$key];
        }else{
            return '';
        }
    }

    // Amazon
    private function get_expiration_intent_info_amazon($key){
        $expiration_intents = [
            '0' => "The cancel reason is currently unavailable and will render at a later time.",
            '1' => "Your customer cancelled the order.",
            '2' => "The purchase was cancelled by Amazon's system",
            '3' => "Other"
        ];
        if(array_key_exists($key, $expiration_intents)){
            return $expiration_intents[$key];
        }else{
            return '';
        }
    }
    
    // Apple
    private function get_app_store_price($product_id, $notification_type){
        if(in_array($notification_type, IOS_PRICING_NOTIFICATION_STATUS)){
            return IOS_SUBSCRIPTION_PACKAGE_LIST[$product_id];
        }
        return 0;
    }

    // Amazon
    private function get_app_store_price_amazon($product_id, $notification_type){
        if(in_array($notification_type, AMAZON_PRICING_NOTIFICATION_STATUS)){
            return AMAZON_SUBSCRIPTION_PACKAGE_LIST[$product_id];
        }
        return 0;
    }

    // Apple
    private function validate_and_store_webhook_data($obj){
        $transaction = [
            'notification_store' => APP_STORE_APPLE,
            'notification_type' => $obj['notification_type'],
            'environment' => $obj['environment'],
            'auto_renew_product_id' => $obj['auto_renew_product_id'],
            'auto_renew_status' => ($obj['auto_renew_status'] === "true"),
            'auto_renew_status_change_date_ms' => $obj['auto_renew_status_change_date_ms'] ?? 0,
            'password' => $obj['password'],
            'bid' => $obj['bid'],
            'bvrs' => $obj['bvrs'],
            'latest_receipt' => $obj['unified_receipt']['latest_receipt'],
            'in_app_ownership_type' => $obj['unified_receipt']['latest_receipt_info'][0]['in_app_ownership_type'],
            'purchase_date_ms' => $obj['unified_receipt']['latest_receipt_info'][0]['purchase_date_ms'],
            'original_purchase_date_ms' => $obj['unified_receipt']['latest_receipt_info'][0]['original_purchase_date_ms'],
            'transaction_id' => $obj['unified_receipt']['latest_receipt_info'][0]['transaction_id'],
            'original_transaction_id' => $obj['unified_receipt']['latest_receipt_info'][0]['original_transaction_id'],
            'quantity' => $obj['unified_receipt']['latest_receipt_info'][0]['quantity'],
            'expires_date_ms' => $obj['unified_receipt']['latest_receipt_info'][0]['expires_date_ms'],
            'product_id' => $obj['unified_receipt']['latest_receipt_info'][0]['product_id'],
            'is_trial_period' => ($obj['unified_receipt']['latest_receipt_info'][0]['is_trial_period'] === "true"),
            'is_in_intro_offer_period' => ($obj['unified_receipt']['latest_receipt_info'][0]['is_in_intro_offer_period'] === "true"),
            'expiration_intent' => $this->get_expiration_intent_info($obj['unified_receipt']['pending_renewal_info'][0]['expiration_intent'] ?? ''),
            'cancellation_date_ms' => $obj['cancellation_date_ms'] ?? 0,
            'price' => $this->get_app_store_price($obj['unified_receipt']['latest_receipt_info'][0]['product_id'], $obj['notification_type']),
        ];
        $this->store_transaction_details($transaction);
    }

    // Apple V2
    private function validate_and_store_v2_webhook_data($obj){
        $token = $obj['signedPayload'];
        $decoded_token = jwt_decode($token);
        $decoded_token_body = $decoded_token['body'];
        mylog('Decoded Token Body');
        mylog($decoded_token_body);
        $decoded_token_data = $decoded_token_body['data'];
        $transactions = jwt_decode($decoded_token_data['signedTransactionInfo']);
        mylog('Transactions');
        mylog($transactions);
        $transactions_data = $transactions['body'];
        mylog('Transactions Data');
        mylog($transactions_data);
        $renewals = jwt_decode($decoded_token_data['signedRenewalInfo']);
        $renewals_data = $renewals['body'];
        mylog('Renewals Data');
        mylog($renewals_data);

        $transaction = [
            'notification_store' => APP_STORE_APPLE,
            'notification_type' => $decoded_token_body['notificationType'],
            'sub_type' => $decoded_token_body['subtype'],
            'environment' => $decoded_token_data['environment'],
            'auto_renew_product_id' => $renewals_data['autoRenewProductId'],
            'auto_renew_status' => $renewals_data['autoRenewStatus'],
            'auto_renew_status_change_date_ms' => $renewals_data['signedDate'],
            'password' => '',
            'bid' => $decoded_token_data['bundleId'],
            'bvrs' => $decoded_token_data['bundleVersion'],
            'latest_receipt' => '',
            'in_app_ownership_type' => $transactions_data['inAppOwnershipType'],
            'purchase_date_ms' => $transactions_data['purchaseDate'],
            'original_purchase_date_ms' => $transactions_data['originalPurchaseDate'],
            'transaction_id' => $transactions_data['transactionId'],
            'original_transaction_id' => $transactions_data['originalTransactionId'],
            'quantity' => $transactions_data['quantity'],
            'expires_date_ms' => $transactions_data['expiresDate'],
            'product_id' => $transactions_data['productId'],
            'is_trial_period' => (!empty($transactions_data['offerType'] ?? '') && $transactions_data['offerType'] == "1" && $decoded_token_body['notificationType'] == "SUBSCRIBED"),
            'is_in_intro_offer_period' => (!empty($renewals_data['offerType'] ?? '')),
            'expiration_intent' => $this->get_expiration_intent_info($renewals_data['expirationIntent'] ?? ''),
            'cancellation_date_ms' => $transactions_data['cancellationDate'] ?? 0,
            'price' => $this->get_app_store_price($transactions_data['productId'], $decoded_token_body['notificationType']),
        ];
        $this->store_transaction_details($transaction);
    }

    private function validate_and_store_webhook_data_amazon($obj){
        $subscription = $this->app_store_amazon->getReceiptInfo($obj['Message']['appUserId'], $obj['Message']['receiptId']);
        $transaction = [
            'notification_store' => APP_STORE_AMAZON,
            'notification_type' => $obj['Message']['notificationType'],
            'environment' => ($obj['Message']['betaProductTransaction']) ? 'Sandbox' : 'PROD',
            'auto_renew_product_id' => $subscription['data']['termSku'],
            'auto_renew_status' => $subscription['data']['autoRenewing'],
            'auto_renew_status_change_date_ms' => (fnmatch("SUBSCRIPTION_AUTO_RENEWAL_*",$obj['Message']['notificationType'])) ? $obj['Message']['timestamp'] : 0,
            'password' => '',
            'bid' => '',
            'bvrs' => '',
            'latest_receipt' => $obj['Message']['receiptId'],
            'in_app_ownership_type' => 'PURCHASED',
            'purchase_date_ms' => $subscription['data']['purchaseDate'],
            'original_purchase_date_ms' => $subscription['data']['purchaseDate'],
            'transaction_id' => $obj['MessageId'],
            'original_transaction_id' => $obj['Message']['appUserId'],
            'quantity' => 1,
            'expires_date_ms' => $subscription['data']['renewalDate'] ?? $subscription['data']['cancelDate'],
            'product_id' => $subscription['data']['termSku'],
            'is_trial_period' => boolval($subscription['data']['freeTrialEndDate']),
            'is_in_intro_offer_period' => 0,
            'expiration_intent' => $this->get_expiration_intent_info_amazon($subscription['data']['cancelReason'] ?? ''),
            'cancellation_date_ms' => $subscription['data']['cancelDate'] ?? 0,
            'price' => $this->get_app_store_price_amazon($subscription['data']['termSku'], $obj['Message']['notificationType']),
        ];
        $this->store_transaction_details($transaction);
    }

    public function activate_vpn_wholesaler(){
        $rules = [
            'original_transaction_id' => [
                'field' => 'original_transaction_id', 'label' => 'Org. Transaction ID', 'rules' => 'required|trim'
            ],
            'product_id' => [
                'field' => 'product_id', 'label' => 'Product ID', 'rules' => 'required|trim|in_list[com.optimal.vpn.streamingmonth,com.optimal.vpn.streamingyear]'
            ],
        ];
        checkIfValidated($rules);
        $transaction = $this->input->post();
        $this->renew_vpn_user($transaction);
        echo 'Activated';
    }

    private function renew_vpn_user($transaction){
        $params = ['where'=>['usubscription.original_transaction_id'=>$transaction['original_transaction_id'],'SINGLE_WHERE'=>'device.wholesaler_user IS NOT NULL']];
        $wholesaler_users = $this->webhook_model->fetch_wholesaler_users($params);
        if(!empty($wholesaler_users) && count($wholesaler_users) > 0){
            foreach ($wholesaler_users as $user) {
                $monthly_plans = ['com.optimal.vpn.streamingmonth','com.V3Pgq6rK.streaming.monthly'];
                $yearly_plans = ['com.optimal.vpn.streamingyear','com.V3Pgq6rK.streaming.yearly'];
                if(in_array($transaction['product_id'],$monthly_plans)){
                    $this->vpn->renew($user['wholesaler_user'], 1);
                    $wholesaler_id = $user['user_device_id'];
                    $this->guest_user_model->activeSubscriptionPlan($wholesaler_id);
                }elseif(in_array($transaction['product_id'],$yearly_plans)){
                    $this->vpn->renew($user['wholesaler_user'], 12);
                    $wholesaler_id = $user['user_device_id'];
                    $this->guest_user_model->activeSubscriptionPlan($wholesaler_id);
                }
            }
        }
    }

    private function store_transaction_details($transaction){
        $flag = $this->webhook_model->storeWebhookData($transaction);
        if(!$flag){
            echo $this->db->_error_message()."\n";
        }else{
            if(
                in_array($transaction["notification_type"], ["INTERACTIVE_RENEWAL","DID_RENEW","DID_RECOVER"]) || 
                ($transaction["notification_type"] == "SUBSCRIBED" && $transaction["sub_type"] == "RESUBSCRIBE")
            ){
                $this->renew_vpn_user($transaction);
            }
            echo 'Webhook details captured successfully'."\n";
        }
    }
}